/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class SetProgramPropertyAction
extends ProvisioningAction {
    public static final String ID = "setProgramProperty";

    public IStatus execute(Map parameters) {
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String propName = (String)parameters.get("propName");
        if (propName == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"propName", (Object)ID));
        }
        String propValue = (String)parameters.get("propValue");
        if (propValue == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"propValue", (Object)ID));
        }
        this.getMemento().put("previousValue", (Object)manipulator.getConfigData().getFwDependentProp(propName));
        manipulator.getConfigData().setFwDependentProp(propName, propValue);
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String propName = (String)parameters.get("propName");
        if (propName == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"propName", (Object)ID));
        }
        String previousValue = (String)this.getMemento().get("previousValue");
        if (previousValue == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"previousValue", (Object)ID));
        }
        manipulator.getConfigData().setFwDependentProp(propName, previousValue);
        return Status.OK_STATUS;
    }
}

