/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent.iis;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.maxent.Convert;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.util.MutableDouble;
import java.text.NumberFormat;

public class LambdaSolve {
    public double[] lambda;
    public boolean[] lambda_converged;
    public double eps;
    public double newtonerr;
    public boolean fixedFnumXY;
    public Problem p;
    public double[][] probConds;
    public double[] zlambda;
    public byte[][] fnumArr;
    public double[] ftildeArr;
    public static boolean smooth = false;
    private static boolean VERBOSE = false;
    private static boolean ASSUME_BINARY = false;
    private double[] aux;
    private double[][] sum;
    private double[][] sub;
    public boolean weightRanks;
    public boolean convertValues;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public LambdaSolve(Problem p1, double eps1, double nerr1) {
        block8: {
            int i;
            block7: {
                block6: {
                    block5: {
                        this.weightRanks = false;
                        this.convertValues = false;
                        this.p = p1;
                        this.eps = eps1;
                        this.newtonerr = nerr1;
                        this.lambda = new double[p1.fSize];
                        this.lambda_converged = new boolean[p1.fSize];
                        Experiments cfr_ignored_0 = this.p.data;
                        this.probConds = new double[Experiments.xSize][];
                        Experiments cfr_ignored_1 = this.p.data;
                        System.out.println("xSize is " + Experiments.xSize);
                        i = 0;
                        if (!true) break block5;
                        Experiments cfr_ignored_2 = this.p.data;
                        if (i >= Experiments.xSize) break block6;
                    }
                    do {
                        this.probConds[i] = new double[this.p.data.numY(i)];
                        ++i;
                        Experiments cfr_ignored_3 = this.p.data;
                    } while (i < Experiments.xSize);
                }
                Experiments cfr_ignored_4 = this.p.data;
                this.fnumArr = new byte[Experiments.xSize][];
                i = 0;
                if (!true) break block7;
                Experiments cfr_ignored_5 = this.p.data;
                if (i >= Experiments.xSize) break block8;
            }
            do {
                this.fnumArr[i] = new byte[this.p.data.numY(i)];
                ++i;
                Experiments cfr_ignored_6 = this.p.data;
            } while (i < Experiments.xSize);
        }
        Experiments cfr_ignored_7 = this.p.data;
        this.zlambda = new double[Experiments.xSize];
        this.ftildeArr = new double[this.p.fSize];
        this.initCondsZlambdaEtc();
        if (this.convertValues) {
            this.transformValues();
        }
    }

    public LambdaSolve(String filename) {
        this.weightRanks = false;
        this.convertValues = false;
        this.read(filename);
    }

    public LambdaSolve() {
        this.weightRanks = false;
        this.convertValues = false;
    }

    public void setNonBinary() {
        ASSUME_BINARY = false;
    }

    public void setBinary() {
        ASSUME_BINARY = true;
    }

    public void transformValues() {
        int x = 0;
        while (x < this.p.data.values.length) {
            double highest = this.p.data.values[x][0];
            double sumhighest = 0.0;
            double sumrest = 0.0;
            int y = 0;
            while (y < this.p.data.values[x].length) {
                if (this.p.data.values[x][y] > highest) {
                    highest = this.p.data.values[x][y];
                }
                ++y;
            }
            y = 0;
            while (y < this.p.data.values[x].length) {
                if (this.p.data.values[x][y] == highest) {
                    sumhighest += highest;
                } else {
                    sumrest += this.p.data.values[x][y];
                }
                ++y;
            }
            if (sumrest != 0.0) {
                y = 0;
                while (y < this.p.data.values[x].length) {
                    this.p.data.values[x][y] = this.p.data.values[x][y] == highest ? 0.7 * highest / sumhighest : 0.3 * this.p.data.values[x][y] / sumrest;
                    ++y;
                }
            }
            ++x;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void initCondsZlambdaEtc() {
        block21: {
            int x;
            byte constAll;
            block20: {
                block19: {
                    int x2;
                    block18: {
                        block17: {
                            block16: {
                                x2 = 0;
                                if (!true) break block16;
                                Experiments cfr_ignored_0 = this.p.data;
                                if (x2 >= Experiments.xSize) break block17;
                            }
                            do {
                                int y = 0;
                                while (y < this.probConds[x2].length) {
                                    this.probConds[x2][y] = 1.0 / (double)this.probConds[x2].length;
                                    ++y;
                                }
                                ++x2;
                                Experiments cfr_ignored_1 = this.p.data;
                            } while (x2 < Experiments.xSize);
                        }
                        if (VERBOSE) {
                            System.err.println(" pcond initialized ");
                        }
                        x2 = 0;
                        if (!true) break block18;
                        Experiments cfr_ignored_2 = this.p.data;
                        if (x2 >= Experiments.xSize) break block19;
                    }
                    do {
                        this.zlambda[x2] = this.probConds[x2].length;
                        ++x2;
                        Experiments cfr_ignored_3 = this.p.data;
                    } while (x2 < Experiments.xSize);
                }
                if (VERBOSE) {
                    System.err.println(" zlambda initialized ");
                }
                int i = 0;
                while (i < this.p.fSize) {
                    this.ftildeArr[i] = this.p.functions.get(i).ftilde();
                    this.p.functions.get(i).setSum();
                    double cfr_ignored_4 = this.ftildeArr[i];
                    if (smooth) {
                        double alfa = 0.015;
                        int j = 0;
                        while (j < this.p.fSize) {
                            Experiments cfr_ignored_5 = this.p.data;
                            Experiments cfr_ignored_6 = this.p.data;
                            this.ftildeArr[j] = (this.ftildeArr[j] * (double)Experiments.xSize + alfa) / (double)Experiments.xSize;
                            ++j;
                        }
                    }
                    Feature f = this.p.functions.get(i);
                    int j = 0;
                    while (j < f.len()) {
                        int x3 = f.getX(j);
                        int y = f.getY(j);
                        byte[] byArray = this.fnumArr[x3];
                        int n = y;
                        byArray[n] = (byte)((double)byArray[n] + f.getVal(j));
                        ++j;
                    }
                    ++i;
                }
                constAll = this.fnumArr[0][0];
                this.fixedFnumXY = true;
                x = 0;
                if (!true) break block20;
                Experiments cfr_ignored_7 = this.p.data;
                if (x >= Experiments.xSize) break block21;
            }
            do {
                int y = 0;
                while (y < this.fnumArr[x].length) {
                    if (this.fnumArr[x][y] != constAll) {
                        this.fixedFnumXY = false;
                        break;
                    }
                    ++y;
                }
                ++x;
                Experiments cfr_ignored_8 = this.p.data;
            } while (x < Experiments.xSize);
        }
        if (VERBOSE) {
            System.err.println(" ftildeArr initialized " + (this.fixedFnumXY ? "fixed sum " : ""));
        }
    }

    public void ImprovedIterative() {
        boolean flag;
        int iterations = 0;
        int numNConverged = this.p.fSize;
        do {
            if (VERBOSE) {
                System.err.println(iterations);
            }
            flag = false;
            ++iterations;
            int i = 0;
            while (i < this.lambda.length) {
                if (!this.lambda_converged[i]) {
                    MutableDouble deltaI = new MutableDouble();
                    boolean fl = this.Iterate(i, this.eps, deltaI);
                    if (fl) {
                        flag = true;
                        this.updateConds(i, deltaI.doubleValue());
                    } else {
                        --numNConverged;
                    }
                }
                ++i;
            }
        } while (flag && iterations < 1000);
    }

    public void ImprovedIterative(int iters) {
        int iterations = 0;
        int numNConverged = this.p.fSize;
        do {
            boolean fl = false;
            ++iterations;
            int i = 0;
            while (i < this.lambda.length) {
                if (!this.lambda_converged[i]) {
                    MutableDouble deltaI = new MutableDouble();
                    fl = this.Iterate(i, this.eps, deltaI);
                    if (fl) {
                        this.updateConds(i, deltaI.doubleValue());
                    } else {
                        --numNConverged;
                    }
                }
                ++i;
            }
            if (iterations % 100 == 0) {
                this.save_lambdas(String.valueOf(iterations) + ".lam");
            }
            System.err.println(iterations);
        } while (iterations < iters);
    }

    boolean Iterate(int index, double err, MutableDouble ret) {
        double deltaL = 0.0;
        if (Math.abs((deltaL = this.newton(deltaL, index, err)) + this.lambda[index]) > 200.0) {
            deltaL = deltaL + this.lambda[index] > 200.0 ? 200.0 - this.lambda[index] : -this.lambda[index] - 200.0;
            System.err.println("set delta to smth " + deltaL);
        }
        this.lambda[index] = this.lambda[index] + deltaL;
        if (deltaL != deltaL) {
            System.err.println(" NaN " + index + " " + deltaL);
        }
        ret.set(deltaL);
        return Math.abs(deltaL) >= this.eps;
    }

    double newton(double lambda0, int index, double err) {
        double lambdaN = lambda0;
        double lambdaP = lambda0;
        int i = 0;
        double gVal = 0.0;
        double gPrimeVal = 0.0;
        if (this.fixedFnumXY) {
            double plambda = this.fExpected(this.p.functions.get(index));
            return 1.0 / (double)this.fnumArr[0][0] * (Math.log(this.ftildeArr[index]) - Math.log(plambda));
        }
        do {
            ++i;
            lambdaP = lambdaN;
            gPrimeVal = this.gprime(lambdaP, index);
            if (gPrimeVal != gPrimeVal) {
                System.err.println("gPrime of " + lambdaP + " " + index + " is NaN " + gPrimeVal);
            }
            gVal = this.g(lambdaP, index);
            if (gPrimeVal == 0.0) {
                return 0.0;
            }
            lambdaN = lambdaP - gVal / gPrimeVal;
            if (lambdaN != lambdaN) {
                System.err.println("the division of " + gVal + " " + gPrimeVal + " " + index + " is NaN " + lambdaN);
                return 0.0;
            }
            if (!(Math.abs(lambdaN - lambdaP) < err)) continue;
            return lambdaN;
        } while (i <= 100);
        if (Math.abs(gVal) > 0.01) {
            return 0.0;
        }
        return lambdaN;
    }

    void updateConds(int index, double deltaL) {
        double zlambdaX = 1.0;
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            double s = 0.0;
            int x = this.p.functions.get(index).getX(i);
            int y = this.p.functions.get(index).getY(i);
            double val = this.p.functions.get(index).getVal(i);
            zlambdaX = this.zlambda[x] + this.pcond(y, x) * this.zlambda[x] * (Math.exp(deltaL * val) - 1.0);
            int y1 = 0;
            while (y1 < this.probConds[x].length) {
                this.probConds[x][y1] = this.probConds[x][y1] * this.zlambda[x] / zlambdaX;
                s += this.probConds[x][y1];
                ++y1;
            }
            s -= this.probConds[x][y];
            this.probConds[x][y] = this.probConds[x][y] * Math.exp(deltaL * val);
            s += this.probConds[x][y];
            this.zlambda[x] = zlambdaX;
            if (Math.abs(s - 1.0) > 0.001) {
                // empty if block
            }
            ++i;
        }
    }

    public double pcond(int y, int x) {
        return this.probConds[x][y];
    }

    protected double fnum(int x, int y) {
        return this.fnumArr[x][y];
    }

    double g(double lambdaP, int index) {
        double s = 0.0;
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            int y = this.p.functions.get(index).getY(i);
            int x = this.p.functions.get(index).getX(i);
            Math.exp(lambdaP * this.fnum(x, y));
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * this.p.functions.get(index).getVal(i) * Math.exp(lambdaP * this.fnum(x, y));
            ++i;
        }
        return s -= this.ftildeArr[index];
    }

    double gprime(double lambdaP, int index) {
        double s = 0.0;
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            int y = this.p.functions.get(index).getY(i);
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * this.p.functions.get(index).getVal(i) * Math.exp(lambdaP * this.fnum(x, y)) * this.fnum(x, y);
            ++i;
        }
        return s;
    }

    double fExpected(Feature f) {
        double s = 0.0;
        int i = 0;
        while (i < f.len()) {
            int x = f.getX(i);
            int y = f.getY(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * f.getVal(i);
            ++i;
        }
        return s;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public boolean checkCorrectness() {
        boolean flag;
        block10: {
            int x;
            block9: {
                flag = true;
                int f = 0;
                while (f < this.lambda.length) {
                    if (Math.abs(this.lambda[f]) > 100.0) {
                        System.out.println(" Lambda too big " + this.lambda[f]);
                        System.out.println(" empirical " + this.ftildeArr[f] + " expeced " + this.fExpected(this.p.functions.get(f)));
                    }
                    ++f;
                }
                Experiments cfr_ignored_0 = this.p.data;
                Experiments cfr_ignored_1 = this.p.data;
                System.out.println(" x size" + Experiments.xSize + " " + " ysize " + Experiments.ySize);
                double summAllExp = 0.0;
                int i = 0;
                while (i < this.ftildeArr.length) {
                    double exp = Math.abs(this.ftildeArr[i] - this.fExpected(this.p.functions.get(i)));
                    summAllExp += this.ftildeArr[i];
                    if (exp > 0.001) {
                        flag = false;
                        System.out.println("Constraint not satisfied  " + i + " " + this.fExpected(this.p.functions.get(i)) + " " + this.ftildeArr[i] + " lambda " + this.lambda[i]);
                    }
                    ++i;
                }
                System.out.println(" The sum of all empirical expectations is " + summAllExp);
                x = 0;
                if (!true) break block9;
                Experiments cfr_ignored_2 = this.p.data;
                if (x >= Experiments.xSize) break block10;
            }
            do {
                double s = 0.0;
                int y = 0;
                while (y < this.probConds[x].length) {
                    s += this.probConds[x][y];
                    ++y;
                }
                if (Math.abs(s - 1.0) > 1.0E-4) {
                    y = 0;
                    while (y < this.probConds[x].length) {
                        System.out.println("probabilities do not sum to one " + x + " " + (float)s);
                        ++y;
                    }
                }
                ++x;
                Experiments cfr_ignored_3 = this.p.data;
            } while (x < Experiments.xSize);
        }
        return flag;
    }

    double ZAlfa(double alfa, Feature f, int x) {
        double s = 0.0;
        int y = 0;
        while (y < this.probConds[x].length) {
            s += this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
            ++y;
        }
        return s;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    double GSF(double alfa, Feature f, int index) {
        double s;
        block3: {
            int x;
            block2: {
                s = 0.0;
                x = 0;
                if (!true) break block2;
                Experiments cfr_ignored_0 = this.p.data;
                if (x >= Experiments.xSize) break block3;
            }
            do {
                s -= this.p.data.ptildeX(x) * Math.log(this.ZAlfa(alfa, f, x));
                ++x;
                Experiments cfr_ignored_1 = this.p.data;
            } while (x < Experiments.xSize);
        }
        return s + alfa * this.ftildeArr[index];
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    double GSF(double alfa, Feature f) {
        double s;
        block3: {
            int x;
            block2: {
                s = 0.0;
                x = 0;
                if (!true) break block2;
                Experiments cfr_ignored_0 = this.p.data;
                if (x >= Experiments.xSize) break block3;
            }
            do {
                s -= this.p.data.ptildeX(x) * Math.log(this.ZAlfa(alfa, f, x));
                ++x;
                Experiments cfr_ignored_1 = this.p.data;
            } while (x < Experiments.xSize);
        }
        return s + alfa * f.ftilde();
    }

    double pcondFAlfa(double alfa, int x, int y, Feature f) {
        double s = 1.0 / this.ZAlfa(alfa, f, x) * this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
        return s;
    }

    double GSFPrime(double alfa, Feature f, int index) {
        double s = 0.0;
        s += this.ftildeArr[index];
        int x1 = 0;
        while (x1 < f.indexedValues.length) {
            double s1 = 0.0;
            int x = f.getX(x1);
            int y = f.getY(x1);
            s -= this.p.data.ptildeX(x) * (s1 += this.pcondFAlfa(alfa, x, y, f) * f.getVal(x1));
            ++x1;
        }
        return s;
    }

    double GSFPrime(double alfa, Feature f) {
        double s = 0.0;
        s += f.ftilde();
        int x1 = 0;
        while (x1 < f.indexedValues.length) {
            double s1 = 0.0;
            int x = f.getX(x1);
            int y = f.getY(x1);
            s -= this.p.data.ptildeX(x) * (s1 += this.pcondFAlfa(alfa, x, y, f) * f.getVal(x1));
            ++x1;
        }
        return s;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    double GSFSecond(double alfa, Feature f) {
        double s;
        block5: {
            int x;
            block4: {
                s = 0.0;
                x = 0;
                if (!true) break block4;
                Experiments cfr_ignored_0 = this.p.data;
                if (x >= Experiments.xSize) break block5;
            }
            do {
                double psff;
                double s1;
                block7: {
                    int y1;
                    block6: {
                        s1 = 0.0;
                        psff = 0.0;
                        y1 = 0;
                        if (!true) break block6;
                        Experiments cfr_ignored_1 = this.p.data;
                        if (y1 >= Experiments.ySize) break block7;
                    }
                    do {
                        psff += this.pcondFAlfa(alfa, x, y1, f) * f.getVal(x, y1);
                        ++y1;
                        Experiments cfr_ignored_2 = this.p.data;
                    } while (y1 < Experiments.ySize);
                }
                int y = 0;
                while (y < this.probConds[x].length) {
                    s1 += this.pcondFAlfa(alfa, x, y, f) * (f.getVal(x, y) - psff) * (f.getVal(x, y) - psff);
                    ++y;
                }
                s -= s1 * this.p.data.ptildeX(x);
                ++x;
                Experiments cfr_ignored_3 = this.p.data;
            } while (x < Experiments.xSize);
        }
        return s;
    }

    public double GainCompute(Feature f, double errorGain) {
        double r = f.ftilde() > this.fExpected(f) ? 1.0 : -1.0;
        f.initHashVals();
        int iterations = 0;
        double alfa = 0.0;
        this.GSF(alfa, f);
        double gsfValNew = 0.0;
        double alfanext = 0.0;
        while (iterations < 30) {
            ++iterations;
            alfanext = alfa + r * Math.log(1.0 - r * this.GSFPrime(alfa, f) / this.GSFSecond(alfa, f));
            gsfValNew = this.GSF(alfanext, f);
            if (Math.abs(alfanext - alfa) < errorGain) {
                return gsfValNew;
            }
            alfa = alfanext;
        }
        return gsfValNew;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void print() {
        block4: {
            int i;
            block3: {
                i = 0;
                if (!true) break block3;
                Experiments cfr_ignored_0 = this.p.data;
                if (i >= Experiments.xSize) break block4;
            }
            do {
                int j = 0;
                while (j < this.probConds[i].length) {
                    System.out.println("P(" + j + " | " + i + ") = " + this.pcond(j, i));
                    ++j;
                }
                ++i;
                Experiments cfr_ignored_1 = this.p.data;
            } while (i < Experiments.xSize);
        }
    }

    public void save(String filename) {
        this.save_lambdas(filename);
    }

    public void save_lambdas(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            LambdaSolve.save_lambdas(rf, this.lambda);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save_lambdas(OutDataStreamFile rf, double[] lambdas) {
        try {
            rf.writeInt(lambdas.length);
            byte[] lArr = Convert.doubleArrToByteArr(lambdas);
            rf.write(lArr);
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readL(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            this.readL(rf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void readL(InDataStreamFile rf) {
        try {
            int funsize = rf.readInt();
            this.lambda = new double[funsize];
            byte[] b = new byte[8 * funsize];
            rf.read(b);
            this.lambda = Convert.byteArrToDoubleArr(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            this.readL(rf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    double[] read_lambdas(String modelFilename) {
        if (VERBOSE) {
            System.err.println(" entering read ");
        }
        try {
            InDataStreamFile rf = new InDataStreamFile(modelFilename);
            return LambdaSolve.read_lambdas(rf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static double[] read_lambdas(InDataStreamFile rf) {
        if (VERBOSE) {
            System.err.println(" entering read ");
        }
        try {
            int funsize = rf.readInt();
            byte[] b = new byte[funsize * 8];
            rf.read(b);
            double[] lambdaold = Convert.byteArrToDoubleArr(b);
            rf.close();
            return lambdaold;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void save_problem(String filename) {
        try {
            PrintFile pf = new PrintFile(filename);
            Experiments cfr_ignored_0 = this.p.data;
            int N = Experiments.xSize;
            Experiments cfr_ignored_1 = this.p.data;
            int M = Experiments.ySize;
            int F = this.p.fSize;
            new String("\n").getBytes();
            new String(". ").getBytes();
            pf.println(N);
            pf.println(M);
            pf.println(F);
            int i = 0;
            while (i < N * M) {
                pf.print(i + 1);
                pf.print(". ");
                pf.println(this.p.data.ptildeX(i / M));
                ++i;
            }
            i = 0;
            while (i < this.p.fSize) {
                int[] values = this.p.functions.get((int)i).indexedValues;
                int k = 0;
                while (k < values.length) {
                    pf.print(i + 1);
                    pf.print(". ");
                    pf.print(values[k]);
                    pf.print(" ");
                    pf.println(1);
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < this.p.fSize) {
                pf.print(i + 1);
                pf.print(". ");
                pf.println(this.ftildeArr[i]);
                ++i;
            }
            pf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public double logLikelihood() {
        double sum;
        block3: {
            Problem problem;
            int index;
            block2: {
                sum = 0.0;
                index = 0;
                if (!true) break block2;
                problem = this.p;
                if (index >= problem.data.size()) break block3;
            }
            do {
                int[] example = this.p.data.get(index);
                sum += Math.log(this.pcond(example[1], example[0]));
                ++index;
                problem = this.p;
            } while (index < problem.data.size());
        }
        Problem problem = this.p;
        return sum / (double)problem.data.size();
    }

    public static double divide(double first, double second) {
        return Math.exp(first - second);
    }

    public static void main(String[] args) {
        if (args.length == 3 && args[0].equals("-pad")) {
            LambdaSolve fred = new LambdaSolve();
            fred.readL(args[1]);
            fred.p = new Problem();
            fred.p.data = new Experiments();
            fred.save(args[2]);
        } else if (args.length == 3 && args[0].equals("-strip")) {
            LambdaSolve fred = new LambdaSolve();
            fred.read(args[1]);
            fred.save_lambdas(args[2]);
        } else if (args.length > 0) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            LambdaSolve[] lambdas = new LambdaSolve[args.length];
            System.out.print("           ");
            int i = 0;
            while (i < args.length) {
                lambdas[i] = new LambdaSolve();
                lambdas[i].readL(args[i]);
                System.out.print("  " + args[i]);
                ++i;
            }
            System.out.println();
            int numLambda = lambdas[0].lambda.length;
            int j = 0;
            while (j < numLambda) {
                System.out.print("lambda[" + j + "] = ");
                int i2 = 0;
                while (i2 < args.length) {
                    System.out.print(String.valueOf(nf.format(lambdas[i2].lambda[j])) + "  ");
                    ++i2;
                }
                System.out.println();
                ++j;
            }
        } else {
            LambdaSolve prob = new LambdaSolve("trainhuge.txt.holder.prob");
            prob.save("trainhuge.txt.holder.prob");
            prob.read("trainhuge.txt.holder.prob");
        }
    }

    public double logLikelihoodNeg() {
        double s = 0.0;
        int i = 0;
        while (i < this.probConds.length) {
            int j = 0;
            while (j < this.probConds[i].length) {
                this.probConds[i][j] = 0.0;
                ++j;
            }
            this.zlambda[i] = 0.0;
            ++i;
        }
        int fNo = 0;
        int fSize = this.p.fSize;
        while (fNo < fSize) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = -Math.exp(this.lambda[fNo]);
            double sum = this.ftildeArr[fNo];
            s -= (sum *= (double)this.p.data.getNumber()) * fLambda;
            if (Math.abs(fLambda) > 200.0) {
                System.out.println("lambda " + fNo + " too big: " + fLambda);
            }
            int i2 = 0;
            int length = f.len();
            while (i2 < length) {
                int x = f.getX(i2);
                int y = f.getY(i2);
                if (ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                } else {
                    double val = f.getVal(i2);
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + val * fLambda;
                }
                ++i2;
            }
            ++fNo;
        }
        int x = 0;
        while (x < this.probConds.length) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            s += this.zlambda[x] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
            int y = 0;
            while (y < this.probConds[x].length) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
                ++y;
            }
            ++x;
        }
        if (s < 0.0) {
            System.out.println("neg log lik smaller than 0 " + s);
        }
        return s;
    }

    public double logLikelihoodScratch() {
        double s = 0.0;
        int i = 0;
        while (i < this.probConds.length) {
            int j = 0;
            while (j < this.probConds[i].length) {
                this.probConds[i][j] = 0.0;
                ++j;
            }
            this.zlambda[i] = 0.0;
            ++i;
        }
        int fNo = 0;
        int fSize = this.p.fSize;
        while (fNo < fSize) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            double sum = this.ftildeArr[fNo];
            s -= (sum *= (double)this.p.data.getNumber()) * fLambda;
            if (Math.abs(fLambda) > 200.0) {
                System.out.println("lambda " + fNo + " too big: " + fLambda);
            }
            int i2 = 0;
            int length = f.len();
            while (i2 < length) {
                int x = f.getX(i2);
                int y = f.getY(i2);
                if (ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                } else {
                    double val = f.getVal(i2);
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + val * fLambda;
                }
                ++i2;
            }
            ++fNo;
        }
        int x = 0;
        while (x < this.probConds.length) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            s += this.zlambda[x] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
            int y = 0;
            while (y < this.probConds[x].length) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
                ++y;
            }
            ++x;
        }
        if (s < 0.0) {
            System.out.println("neg log lik smaller than 0 " + s);
            System.exit(0);
        }
        return s;
    }

    public double[] getDerivatives() {
        double[] drvs = new double[this.lambda.length];
        int fNo = 0;
        while (fNo < drvs.length) {
            Feature f = this.p.functions.get(fNo);
            double sum = this.ftildeArr[fNo] * (double)this.p.data.getNumber();
            drvs[fNo] = -sum;
            int index = 0;
            int length = f.len();
            while (index < length) {
                int x = f.getX(index);
                int y = f.getY(index);
                if (ASSUME_BINARY) {
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
                } else {
                    double val = f.getVal(index);
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * val * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
                }
                ++index;
            }
            ++fNo;
        }
        return drvs;
    }

    public double[] getDerivativesNeg() {
        double[] drvs = new double[this.lambda.length];
        int fNo = 0;
        while (fNo < drvs.length) {
            Feature f = this.p.functions.get(fNo);
            double sum = this.ftildeArr[fNo] * (double)this.p.data.getNumber();
            double lam = -Math.exp(this.lambda[fNo]);
            drvs[fNo] = -sum * lam;
            int index = 0;
            int length = f.len();
            while (index < length) {
                int x = f.getX(index);
                int y = f.getY(index);
                if (ASSUME_BINARY) {
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * lam;
                } else {
                    double val = f.getVal(index);
                    int n = fNo;
                    drvs[n] = drvs[n] + this.probConds[x][y] * val * this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * lam;
                }
                ++index;
            }
            ++fNo;
        }
        return drvs;
    }

    public double expectedValue() {
        double s = 0.0;
        this.aux = new double[this.probConds.length];
        int i = 0;
        while (i < this.probConds.length) {
            int j = 0;
            while (j < this.probConds[i].length) {
                this.probConds[i][j] = 0.0;
                ++j;
            }
            this.zlambda[i] = 0.0;
            ++i;
        }
        int fNo = 0;
        int fSize = this.p.fSize;
        while (fNo < fSize) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            if (Math.abs(fLambda) > 200.0) {
                System.out.println("lambda " + fNo + " too big: " + fLambda);
            }
            int i2 = 0;
            int length = f.len();
            while (i2 < length) {
                int x = f.getX(i2);
                int y = f.getY(i2);
                if (ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                } else {
                    double val = f.getVal(i2);
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + val * fLambda;
                }
                ++i2;
            }
            ++fNo;
        }
        int x = 0;
        while (x < this.probConds.length) {
            this.zlambda[x] = ArrayMath.logSum(this.probConds[x]);
            int y = 0;
            while (y < this.probConds[x].length) {
                this.probConds[x][y] = LambdaSolve.divide(this.probConds[x][y], this.zlambda[x]);
                s -= this.p.data.values[x][y] * this.probConds[x][y] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
                int n = x;
                this.aux[n] = this.aux[n] + this.p.data.values[x][y] * this.probConds[x][y];
                ++y;
            }
            ++x;
        }
        return s;
    }

    public double[] getDerivativesExpectedValue() {
        double[] drvs = new double[this.lambda.length];
        int fNo = 0;
        while (fNo < drvs.length) {
            Feature f = this.p.functions.get(fNo);
            int index = 0;
            int length = f.len();
            while (index < length) {
                int x = f.getX(index);
                int y = f.getY(index);
                double val = f.getVal(index);
                double mult = val * this.probConds[x][y] * this.p.data.ptildeX(x) * (double)this.p.data.getNumber();
                int n = fNo;
                drvs[n] = drvs[n] - mult * this.p.data.values[x][y];
                int n2 = fNo;
                drvs[n2] = drvs[n2] + mult * this.aux[x];
                ++index;
            }
            ++fNo;
        }
        return drvs;
    }

    public double lossDomination() {
        double s = 0.0;
        int i = 0;
        while (i < this.probConds.length) {
            int j = 0;
            while (j < this.probConds[i].length) {
                this.probConds[i][j] = 0.0;
                ++j;
            }
            this.zlambda[i] = 0.0;
            ++i;
        }
        int fNo = 0;
        int fSize = this.p.fSize;
        while (fNo < fSize) {
            Feature f = this.p.functions.get(fNo);
            double fLambda = this.lambda[fNo];
            if (Math.abs(fLambda) > 200.0) {
                System.out.println("lambda " + fNo + " too big: " + fLambda);
            }
            int i2 = 0;
            int length = f.len();
            while (i2 < length) {
                int x = f.getX(i2);
                int y = f.getY(i2);
                if (ASSUME_BINARY) {
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + fLambda;
                } else {
                    double val = f.getVal(i2);
                    double[] dArray = this.probConds[x];
                    int n = y;
                    dArray[n] = dArray[n] + val * fLambda;
                }
                ++i2;
            }
            ++fNo;
        }
        this.sum = new double[this.probConds.length][];
        this.sub = new double[this.probConds.length][];
        int x = 0;
        while (x < this.probConds.length) {
            double weight;
            this.sum[x] = new double[this.probConds[x].length];
            this.sub[x] = new double[this.probConds[x].length];
            double localloss = 0.0;
            int u = 0;
            while (u < this.sum[x].length) {
                boolean hasgraph = false;
                int v = 0;
                while (v < this.sum[x].length) {
                    if (this.p.data.values[x][u] > this.p.data.values[x][v]) {
                        hasgraph = true;
                        double[] dArray = this.sum[x];
                        int n = u;
                        dArray[n] = dArray[n] + Math.exp(this.probConds[x][v] - this.probConds[x][u]);
                    }
                    ++v;
                }
                double[] dArray = this.sum[x];
                int n = u;
                dArray[n] = dArray[n] + 1.0;
                weight = 1.0;
                if (this.weightRanks) {
                    weight = this.p.data.values[x][u];
                }
                if (hasgraph) {
                    int n2 = x;
                    this.zlambda[n2] = this.zlambda[n2] + weight;
                }
                localloss += weight * Math.log(this.sum[x][u]);
                ++u;
            }
            u = 0;
            while (u < this.sum[x].length) {
                int v = 0;
                while (v < this.sum[x].length) {
                    if (this.p.data.values[x][u] > this.p.data.values[x][v]) {
                        weight = 1.0;
                        if (this.weightRanks) {
                            weight = this.p.data.values[x][u];
                        }
                        double[] dArray = this.sub[x];
                        int n = v;
                        dArray[n] = dArray[n] + weight * Math.exp(this.probConds[x][v] - this.probConds[x][u]) / this.sum[x][u];
                    }
                    ++v;
                }
                ++u;
            }
            System.out.println(" for x " + x + " number graphs " + this.zlambda[x]);
            if (this.zlambda[x] > 0.0) {
                s += this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * (localloss /= this.zlambda[x]);
            }
            ++x;
        }
        return s;
    }

    public double[] getDerivativesLossDomination() {
        double[] drvs = new double[this.lambda.length];
        int fNo = 0;
        while (fNo < drvs.length) {
            Feature f = this.p.functions.get(fNo);
            int index = 0;
            int length = f.len();
            while (index < length) {
                int x = f.getX(index);
                int y = f.getY(index);
                double val = f.getVal(index);
                if (this.zlambda[x] != 0.0) {
                    double mult = val * this.p.data.ptildeX(x) * (double)this.p.data.getNumber() * (1.0 / this.zlambda[x]);
                    double weight = 1.0;
                    if (this.weightRanks) {
                        weight = this.p.data.values[x][y];
                    }
                    int n = fNo;
                    drvs[n] = drvs[n] + mult * this.sub[x][y];
                    int n2 = fNo;
                    drvs[n2] = drvs[n2] - mult * weight * (this.sum[x][y] - 1.0) / this.sum[x][y];
                }
                ++index;
            }
            ++fNo;
        }
        return drvs;
    }
}

