/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Pair;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractEval {
    private static final boolean DEBUG = false;
    protected String str = "";
    private double precision = 0.0;
    private double recall = 0.0;
    private double f1 = 0.0;
    private double num = 0.0;
    private double exact = 0.0;
    private double precision2 = 0.0;
    private double recall2 = 0.0;
    private double pnum2 = 0.0;
    private double rnum2 = 0.0;

    public double getSentAveF1() {
        return this.f1 / this.num;
    }

    public double getEvalbF1() {
        return 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
    }

    protected double precision(Set s1, Set s2) {
        double n = 0.0;
        double p = 0.0;
        for (Object o1 : s1) {
            if (s2.contains(o1)) {
                p += 1.0;
            }
            n += 1.0;
        }
        return n > 0.0 ? p / n : 0.0;
    }

    abstract Set makeObjects(Tree var1);

    public void evaluate(Tree guess, Tree gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        Set dep1 = this.makeObjects(guess);
        Set dep2 = this.makeObjects(gold);
        double curPrecision = this.precision(dep1, dep2);
        double curRecall = this.precision(dep2, dep1);
        double curF1 = curPrecision > 0.0 && curRecall > 0.0 ? 2.0 / (1.0 / curPrecision + 1.0 / curRecall) : 0.0;
        this.precision += curPrecision;
        this.recall += curRecall;
        this.f1 += curF1;
        this.num += 1.0;
        this.precision2 += (double)dep1.size() * curPrecision;
        this.pnum2 += (double)dep1.size();
        this.recall2 += (double)dep2.size() * curRecall;
        this.rnum2 += (double)dep2.size();
        if (curF1 > 0.9999) {
            this.exact += 1.0;
        }
        pw.println(" P: " + (double)((int)(curPrecision * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.precision * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precision2 * 10000.0 / this.pnum2)) / 100.0 + ")");
        pw.println(" R: " + (double)((int)(curRecall * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.recall * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recall2 * 10000.0 / this.rnum2)) / 100.0 + ")");
        double cF1 = 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
        String emit = this.str + " F1: " + (double)((int)(curF1 * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(10000.0 * this.f1 / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")   Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0 + " N: " + (int)this.num;
        pw.println(emit);
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    public void display(boolean verbose, PrintWriter pw) {
        double prec = this.precision2 / this.pnum2;
        double rec = this.recall2 / this.rnum2;
        double f = 2.0 / (1.0 / prec + 1.0 / rec);
        pw.println("LP: " + (double)((int)(10000.0 * prec)) / 100.0 + " LR: " + (double)((int)(10000.0 * rec)) / 100.0 + " F1: " + (double)((int)(10000.0 * f)) / 100.0 + " Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0);
    }

    public static class CatErrorEval
    extends AbstractEval {
        private Counter over = new Counter();
        private Counter under = new Counter();

        Set makeObjects(Tree tree) {
            return null;
        }

        List myMakeObjects(Tree tree) {
            LinkedList<String> cats = new LinkedList<String>();
            for (Tree st : tree.subTreeList()) {
                cats.add(st.value());
            }
            return cats;
        }

        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            List s1 = this.myMakeObjects(t1);
            List s2 = this.myMakeObjects(t2);
            LinkedList del2 = new LinkedList(s2);
            for (Object o1 : s1) {
                if (del2.remove(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (Object o2 : s2) {
                if (s1.remove(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        protected void display(Counter c, PrintWriter pw) {
            ArrayList cats = new ArrayList(c.keySet());
            Collections.sort(cats, c.comparator(false));
            for (Object ob : cats) {
                pw.println(ob + " " + c.getCount(ob));
            }
        }

        public void display(boolean verbose, PrintWriter pw) {
            pw.println("Most frequently underproposed categories:");
            this.display(this.under, pw);
            pw.println("Most frequently overproposed categories:");
            this.display(this.over, pw);
        }

        public CatErrorEval(String str) {
            this.str = str;
        }
    }

    public static class RuleErrorEval
    extends AbstractEval {
        private boolean verbose = false;
        private Counter over = new Counter();
        private Counter under = new Counter();

        protected static String localize(Tree tree) {
            if (tree.isLeaf()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(tree.label());
            sb.append(" ->");
            for (int i = 0; i < tree.children().length; ++i) {
                sb.append(" ");
                sb.append(tree.children()[i].label());
            }
            return sb.toString();
        }

        Set makeObjects(Tree tree) {
            HashSet<String> localTrees = new HashSet<String>();
            for (Tree st : tree.subTreeList()) {
                localTrees.add(RuleErrorEval.localize(st));
            }
            return localTrees;
        }

        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set s1 = this.makeObjects(t1);
            Set s2 = this.makeObjects(t2);
            for (Object o1 : s1) {
                if (s2.contains(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (Object o2 : s2) {
                if (s1.contains(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        protected void display(Counter c, int num, PrintWriter pw) {
            ArrayList rules = new ArrayList(c.keySet());
            Collections.sort(rules, c.comparator(false));
            int rSize = rules.size();
            if (num > rSize) {
                num = rSize;
            }
            for (int i = 0; i < num; ++i) {
                pw.println(rules.get(i) + " " + c.getCount(rules.get(i)));
            }
        }

        public void display(boolean verbose, PrintWriter pw) {
            this.verbose = verbose;
            pw.println("Most frequently underproposed rules:");
            this.display(this.under, verbose ? 100 : 10, pw);
            pw.println("Most frequently overproposed rules:");
            this.display(this.over, verbose ? 100 : 10, pw);
        }

        public RuleErrorEval(String str) {
            this.str = str;
        }
    }

    public static class TaggingEval
    extends AbstractEval {
        private static final boolean DEBUG = false;
        private Lexicon lex;

        Set makeObjects(Tree tree) {
            Sentence twList = tree.taggedYield();
            HashSet<Pair<Integer, WordTag>> set = new HashSet<Pair<Integer, WordTag>>();
            for (int i = 0; i < twList.size(); ++i) {
                TaggedWord tw = (TaggedWord)twList.get(i);
                Pair<Integer, WordTag> positionWT = new Pair<Integer, WordTag>(new Integer(i), new WordTag(tw.value(), tw.tag()));
                set.add(positionWT);
            }
            return set;
        }

        public TaggingEval(String str) {
            this.str = str;
        }

        public TaggingEval(String str, Lexicon lex) {
            this(str);
            this.lex = lex;
        }

        public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
            Sentence sGold = gold.taggedYield();
            Sentence sGuess = guess.taggedYield();
            if (sGuess.size() != sGold.size()) {
                pw.println("Warning: yield differs:");
                pw.println("Guess: " + sGuess);
                pw.println("Gold: " + sGold);
            }
            super.evaluate(guess, gold, pw);
        }
    }

    public static class DependencyEval
    extends AbstractEval {
        private static final boolean DEBUG = false;
        Filter punctFilter;

        Set makeObjects(Tree tree) {
            HashSet<UnnamedDependency> deps = new HashSet<UnnamedDependency>();
            for (Tree node : tree.subTreeList()) {
                if (node.isLeaf() || node.children().length < 2) continue;
                String head = ((HasWord)((Object)node.label())).word();
                boolean seenHead = false;
                for (int cNum = 0; cNum < node.children().length; ++cNum) {
                    Tree child = node.children()[cNum];
                    String arg = ((HasWord)((Object)child.label())).word();
                    if (head.equals(arg) && !seenHead) {
                        seenHead = true;
                        continue;
                    }
                    if (this.punctFilter.accept(arg)) continue;
                    deps.add(new UnnamedDependency(head, arg));
                }
            }
            return deps;
        }

        public DependencyEval(String str, Filter punctFilter) {
            this.str = str;
            this.punctFilter = punctFilter;
        }
    }
}

