/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import java.util.ArrayList;

class NegraPennCollinizer
implements TreeTransformer {
    private TreebankLanguagePack tlp = new NegraPennLanguagePack();
    private final boolean deletePunct;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public NegraPennCollinizer() {
        this(true);
    }

    public NegraPennCollinizer(boolean deletePunct) {
        this.deletePunct = deletePunct;
    }

    public Tree transformTree(Tree tree) {
        Label l = tree.label();
        String s = l.value();
        if (tree.isLeaf()) {
            return this.tf.newLeaf(s);
        }
        s = this.tlp.basicCategory(s);
        if (this.deletePunct && tree.isPreTerminal() && this.tlp.isEvalBIgnoredPunctuationTag(s)) {
            return null;
        }
        if (tree.children()[0].label().value().equals("TOPP")) {
            System.err.println("Found a TOPP");
            tree.setChildren(tree.children()[0].children());
        }
        if (this.tlp.isStartSymbol(s) && tree.children().length == 1) {
            return this.transformTree(tree.children()[0]);
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        for (int cNum = 0; cNum < tree.children().length; ++cNum) {
            Tree child = tree.children()[cNum];
            Tree newChild = this.transformTree(child);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.size() == 0) {
            return null;
        }
        return this.tf.newTreeNode(new StringLabel(s), children);
    }
}

