/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.util.ArrayList;
import java.util.HashMap;

public class PairsHolder {
    private HashMap arr = new HashMap();
    private ArrayList arrNum = new ArrayList();

    public int getSize() {
        return this.arrNum.size();
    }

    public int[] getIndexes(Object wordtag) {
        ArrayList<Integer> arr1 = new ArrayList<Integer>();
        int l = wordtag.hashCode();
        Integer lO = new Integer(l);
        int i = 0;
        while (i < this.arrNum.size()) {
            if (this.arrNum.get(i).equals(lO)) {
                arr1.add(new Integer(i));
            }
            ++i;
        }
        int[] ret = new int[arr1.size()];
        int i2 = 0;
        while (i2 < arr1.size()) {
            ret[i2] = (Integer)arr1.get(i2);
            ++i2;
        }
        return ret;
    }

    public void release() {
        this.arr.clear();
        this.arrNum.clear();
    }

    int add(WordTag wordtag) {
        Object o = this.arr.get(wordtag);
        if (o == null) {
            this.arr.put(wordtag, wordtag);
            o = wordtag;
        }
        this.arrNum.add(o);
        return this.arrNum.size() - 1;
    }

    void remove(int start, int end) {
        int i = start;
        while (i < end) {
            this.arrNum.remove(this.arrNum.size() - 1);
            ++i;
        }
    }

    void setTag(int pos, String tag) {
        ((WordTag)this.arrNum.get(pos)).setTag(tag);
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(this.arrNum.size());
            int i = 0;
            while (i < this.arrNum.size()) {
                WordTag wT = (WordTag)this.arrNum.get(i);
                rf.writeUTF(wT.word());
                rf.writeUTF(wT.tag());
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print() {
        try {
            System.out.println(" print pairs ");
            System.out.println(this.arrNum.size());
            int i = 0;
            while (i < this.arrNum.size()) {
                Integer iO = (Integer)this.arrNum.get(i);
                System.out.println((String)this.arr.get(iO));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            int len = rf.readInt();
            int i = 0;
            while (i < len) {
                WordTag wT = new WordTag();
                wT.setWord(rf.readUTF());
                wT.setTag(rf.readUTF());
                this.add(wT);
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String get(int index, boolean isTag) {
        WordTag wT = (WordTag)this.arrNum.get(index);
        if (isTag) {
            return wT.tag();
        }
        return wT.word();
    }

    String get(History h, int position, boolean isTag) {
        if (h.current + position >= h.start && h.current + position <= h.end) {
            return this.get(h.current + position, isTag);
        }
        return TestSentence.toSt("NA");
    }

    public static void main(String[] args) {
        PairsHolder pairsHolder = new PairsHolder();
        new WordTag();
        int i = 0;
        while (i < 10) {
            pairsHolder.add(new WordTag("girl", "NN"));
            ++i;
        }
        GlobalHolder.init();
        GlobalHolder.pairs = pairsHolder;
        History h = new History(0, 5, 3);
        GlobalHolder.tHistories.add(h);
        GlobalHolder.tHistories.getIndex(h);
        Extractor e = new Extractor(0, false);
        String k = e.extract(h);
        System.out.println(k.toString());
    }
}

