/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.MapLabel;
import edu.stanford.nlp.ling.MapLabelFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.util.List;

public class TreeGraphNodeFactory
implements TreeFactory {
    private MapLabelFactory mlf;

    public TreeGraphNodeFactory() {
        this(MapLabel.factory());
    }

    public TreeGraphNodeFactory(LabelFactory mlf) {
        this.mlf = (MapLabelFactory)mlf;
    }

    public Tree newLeaf(String word) {
        return this.newLeaf(this.mlf.newLabel(word));
    }

    public Tree newLeaf(Label label) {
        return new TreeGraphNode(label);
    }

    public Tree newTreeNode(String parent, List children) {
        return this.newTreeNode(this.mlf.newLabel(parent), children);
    }

    public Tree newTreeNode(Label parentLabel, List children) {
        return new TreeGraphNode(parentLabel, children);
    }
}

