/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.international.pennchinese.CHTBTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseGrammaticalStructure
extends GrammaticalStructure {
    private static HeadFinder shf = new ChineseSemanticHeadFinder();

    public ChineseGrammaticalStructure(Tree t) {
        this(t, new ChineseTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public ChineseGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        super(t, ChineseGrammaticalRelations.values(), shf, puncFilter);
    }

    protected void collapseDependencies(Collection<TypedDependency> list) {
        this.collapsePrepAndPoss(list);
    }

    private void collapsePrepAndPoss(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new HashSet());
            }
            ((Set)map.get(typedDep.gov())).add(typedDep);
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            TreeGraphNode td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles == null) continue;
            for (TypedDependency td2 : possibles) {
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if (td2 == null || td1.reln() != GrammaticalRelation.DEPENDENT || td2.reln() != GrammaticalRelation.DEPENDENT || !td1DepPOS.equals("P")) continue;
                TypedDependency td3 = new TypedDependency(td1Dep.value(), td1.gov(), td2.dep());
                newTypedDeps.add(td3);
                td1.setReln(GrammaticalRelation.KILL);
                td2.setReln(GrammaticalRelation.KILL);
            }
            if (!td1.reln().equals(GrammaticalRelation.KILL)) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln().equals(GrammaticalRelation.KILL)) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td : list) {
            if (td.reln().equals(GrammaticalRelation.KILL)) continue;
            newTypedDeps.add(td);
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String hf = props.getProperty("hf");
        try {
            if (hf != null) {
                shf = (HeadFinder)Class.forName(hf).newInstance();
                System.err.println("Using " + hf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to use HeadFinder: " + hf);
        }
        ChineseTreebankParserParams ctpp = new ChineseTreebankParserParams();
        ctpp.setInputEncoding("GB18030");
        ctpp.setOutputEncoding("GB18030");
        if (args.length == 0) {
            System.err.println("Please provide treeFile or sentFile");
        } else {
            if (treeFileName != null) {
                try {
                    Tree t;
                    TreeReaderFactory trf = ctpp.treeReaderFactory();
                    TreeReader tr = trf.newTreeReader(new InputStreamReader((InputStream)new FileInputStream(treeFileName), "GB18030"));
                    while ((t = tr.readTree()) != null) {
                        ((AbstractCollection)tb).add(t);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("File problem: " + e);
                }
            }
            if (sentFileName != null) {
                LexicalizedParser lp = new LexicalizedParser("/u/nlp/data/lexparser/chineseFactored.ser.gz");
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(sentFileName));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot find " + sentFileName);
                    System.exit(1);
                }
                try {
                    String line;
                    System.out.println("Processing sentence file " + sentFileName);
                    while ((line = reader.readLine()) != null) {
                        CHTBTokenizer chtb = new CHTBTokenizer(new StringReader(line));
                        List words = chtb.tokenize();
                        lp.parse(words);
                        Tree parseTree = lp.getBestParse();
                        ((AbstractCollection)tb).add(parseTree);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("IOexception reading key file " + sentFileName);
                    System.exit(1);
                }
            }
        }
        System.out.println("Phrase structure tree, then dependencies, then collapsed dependencies");
        for (Tree t : tb) {
            System.out.println("==================================================");
            ChineseGrammaticalStructure gs = new ChineseGrammaticalStructure(t);
            t.pennPrint();
            System.out.println("----------------------------");
            System.out.println(gs);
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependencies(true), "\n"));
            System.out.println("----------------------------");
            System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
        }
    }
}

