/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class CollectionFactory
implements Serializable {
    public static final CollectionFactory ARRAY_LIST_FACTORY = new ArrayListFactory();
    public static final CollectionFactory HASH_SET_FACTORY = new HashSetFactory();

    public abstract Collection newCollection();

    public abstract Collection newEmptyCollection();

    public static class HashSetFactory
    extends CollectionFactory {
        public Collection newCollection() {
            return new HashSet();
        }

        public Collection newEmptyCollection() {
            return Collections.EMPTY_SET;
        }
    }

    public static class ArrayListFactory
    extends CollectionFactory {
        public Collection newCollection() {
            return new ArrayList();
        }

        public Collection newEmptyCollection() {
            return Collections.EMPTY_LIST;
        }
    }
}

