/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Interner {
    protected static Interner interner = new Interner();
    protected Map map = new WeakHashMap();

    public static Interner getGlobal() {
        return interner;
    }

    public static Interner setGlobal(Interner interner) {
        Interner oldInterner = Interner.interner;
        Interner.interner = interner;
        return oldInterner;
    }

    public static Object globalIntern(Object o) {
        return Interner.getGlobal().intern(o);
    }

    public void clear() {
        this.map = new WeakHashMap();
    }

    public Object intern(Object o) {
        Object i = this.map.get(o);
        if (i == null) {
            i = o;
            this.map.put(i, i);
        }
        return i;
    }

    public Set internAll(Set s) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object o : s) {
            result.add(this.intern(o));
        }
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            System.out.println(Interner.globalIntern(str) == str);
        }
    }
}

