/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;

public abstract class VersionConstraintImpl
implements VersionConstraint {
    private String name;
    private VersionRange versionRange;
    private BundleDescription bundle;
    private BaseDescription supplier;

    public String getName() {
        if ("system.bundle".equals(this.name)) {
            StateImpl state = (StateImpl)this.getBundle().getContainingState();
            return state == null ? Constants.getInternalSymbolicName() : state.getSystemBundle();
        }
        return this.name;
    }

    public VersionRange getVersionRange() {
        if (this.versionRange == null) {
            return VersionRange.emptyRange;
        }
        return this.versionRange;
    }

    public BundleDescription getBundle() {
        return this.bundle;
    }

    public boolean isResolved() {
        return this.supplier != null;
    }

    public BaseDescription getSupplier() {
        return this.supplier;
    }

    public boolean isSatisfiedBy(BaseDescription supplier) {
        return false;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    protected void setBundle(BundleDescription bundle) {
        this.bundle = bundle;
    }

    protected void setSupplier(BaseDescription supplier) {
        this.supplier = supplier;
    }
}

