/* Filename: EntityLabelProvider.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Nov 8, 2007
 */
package nil.ucm.indications2.ui.label;

import nil.ucm.indications2.core.rep.indication.IConstituent;
import nil.ucm.indications2.core.rep.indication.IIndication;
import nil.ucm.indications2.core.rep.indication.IModifier;
import nil.ucm.indications2.core.rep.indication.INucleus;
import nil.ucm.indications2.ui.IndicationsUIConstants;
import nil.ucm.indications2.ui.IndicationsUIPlugin;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class IndicationLabelProvider extends StoryModelLabelProvider {
	
	private Image indImg;
	private Image nucsImg;
	private Image modsImg;
	private Image nucImg;
	private Image modImg;
	
	/**
	 * TODO: Write comment
	 *
	 * @param editor
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public IndicationLabelProvider(IStoryEditor editor){
		super(editor);
	}
	
	/* 
	 * (non-Javadoc) @see org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider#getStyledText(java.lang.Object)
	 */
	@Override
	public StyledString getStyledText(Object element) {
		
		long id = -1;
		if(element instanceof IDesc){
			IDesc d = (IDesc)element;
			element = d.getData();
			id = d.getID();
		}
		
		if(element instanceof IIndication){
			IIndication ind = (IIndication)element;
			StyledString result = new StyledString();
			IRefExp refexp = (IRefExp)ind.getReferringExpression().getData();
			result.append(refexp.getDisplayText());
			if(id >= 0){
				result.append(" (", StyledString.DECORATIONS_STYLER);
				result.append(Long.toString(id), StyledString.DECORATIONS_STYLER);
				result.append(")", StyledString.DECORATIONS_STYLER);
			}
			return result;
		}
		
		if(element instanceof IHasPositionSet){
			IHasPositionSet<?> cons = (IHasPositionSet<?>)element;
			Object first = cons.first();
			if(first instanceof INucleus){
				return new StyledString("nuclei", StyledString.COUNTER_STYLER);
			} else {
				return new StyledString("modifiers", StyledString.COUNTER_STYLER);
			}
		}
		
		if(element instanceof IConstituent){
			IConstituent c = (IConstituent)element;
			StyledString result = new StyledString();
			result.append(c.getSegments().getDisplayText());
			result.append(" - ", StyledString.DECORATIONS_STYLER);
			result.append(c.getType().getName(), StyledString.DECORATIONS_STYLER);
			return result;
		}
		
		return super.getStyledText(element);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.label.StoryModelLabelProvider#getImage(java.lang.Object)
	 */
	@Override
	public Image getImage(Object element) {
		
		if(element instanceof IDesc){
			IDesc d = (IDesc)element;
			element = d.getData();
		}
		
		if(element instanceof IIndication)
			return getIndImg();
		
		if(element instanceof INucleus)
			return getNucImg();
		
		if(element instanceof IModifier)
			return getModImg();
		
		if(element instanceof IHasPositionSet){
			IHasPositionSet<?> set = (IHasPositionSet<?>)element;
			if(set.first() instanceof INucleus){
				return getNucsImg();
			} else {
				return getModsImg();
			}
		}
		
		return super.getImage(element);
	}
	
	protected Image getIndImg(){
		if(indImg == null)
			indImg = IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Reference);
		return indImg;
	}
	
	
	protected Image getNucsImg(){
		if(nucsImg == null)
			nucsImg = IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_NucleusList);
		return nucsImg;
	}
	
	protected Image getModsImg(){
		if(modsImg == null)
			modsImg = IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_ModifierList);
		return modsImg;
	}
	
	protected Image getNucImg(){
		if(nucImg == null)
			nucImg = IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Nucleus);
		return nucImg;
	}
	
	protected Image getModImg(){
		if(modImg == null)
			modImg = IndicationsUIPlugin.getDefault().getImageRegistry().get(IndicationsUIConstants.ICON_Modifier);
		return modImg;
	}
	

}