/* Filename: RemoveModifierChange.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 20/10/2009
 */
package nil.ucm.indications2.core.rep.change;

import java.util.ArrayList;
import java.util.List;

import nil.ucm.indications2.core.IndicationsMessages;
import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructure;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.Modifier;
import nil.ucm.indications2.core.rep.Nucleus;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.IOrigin;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.ReplaceDescriptionChange;
import edu.mit.story.core.model.change.StoryChangeEvent;

/** 
 *   Change for the removal of modifiers from an indicaton structure
 *
 * @author Raquel Hervas
 * @version 1.0, (Oct. 20, 2009)
 * @since nil.ucm.indications.core 1.0.0
 */
public class RemoveModifierChange extends AbstractModelChange {

	private IDesc oldDesc;
	private IModifier modifier;
	private ITiming timing;
	
	public RemoveModifierChange(IDesc ind, IModifier mod, ITiming timing) {
		super(IndicationsMessages.CHANGE_RemoveModifierChange_name);
		
		if(!IndicationStructureRep.getInstance().isType(ind)) throw new IllegalArgumentException();
		
		oldDesc = ind;
		modifier = mod;
		this.timing = timing;
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {

		IIndicationStructure indStruct = (IIndicationStructure)oldDesc.getData();
		
		//We create a new list of modifiers with the change of type of the selected one
		List<IModifier> newMods = new ArrayList<IModifier>();
		boolean found = false;
		for (IModifier oldMod : indStruct.getModifiers()) {
			if(oldMod == modifier){
				found = true;
			} else {
				newMods.add(new Modifier(oldMod.getSegments(), oldMod.getType()));
			}
		}
		if(!found) return null;
		
		List<INucleus> newNucs = new ArrayList<INucleus>();
		for (INucleus oldNuc : indStruct.getNuclei()) {
			newNucs.add(new Nucleus(oldNuc.getSegments(), oldNuc.getType()));
		}
		
		// add the new description
		IIndicationStructure newData = new IndicationStructure(indStruct.getReferentDescription(), indStruct.getReference().getID(), newNucs, newMods, indStruct.isCopularPredicate());
		IDesc newDesc = new Desc(oldDesc.getID(), IndicationStructureRep.getInstance(), newData.calculatePosition(), newData, oldDesc.getMetaData());
		newDesc.getMetaData().addDesc(new MetaDesc<IOrigin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
		if(timing != null)
			newDesc.getMetaData().addDesc(new MetaDesc<ITiming>(TimingMetaRep.getInstance(), newDesc, timing));
		
		IModelChange change = new ReplaceDescriptionChange(getName(), oldDesc, newDesc);
		return change.apply(source, model);
	}

}
