/* Filename: IIndicationStructureModel.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 30/09/2009
 */
package nil.ucm.indications2.core.rep.model;

import java.util.List;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.util.IClearable;


/** 
 *   Interface for the model for the indication structures
 *
 * @author Raquel Hervas
 * @version 1.0, (Sep. 30, 2009)
 * @since nil.ucm.indications.ui 1.0.0
 */
public interface IIndicationStructureModel extends IIndicationStructure, IClearable, IViewModel {

	public IDesc getLoaded();

	public void load(IDesc desc);
	
	public List<INucleusModel> getNuclei();
	
	public List<IModifierModel> getModifiers();

	public IReferenceModel getReference();
	
	public void addNucleus(INucleusModel nuc/*, IndicationType type*/);
	
	public void addModifier(IModifierModel mod);
	
	public void removeModifier(IModifierModel mod);
	
	public void removeNucleus(INucleusModel nuc);
	
	public IIndicationStructure toIndicationStructure();
	
	public void setCopularPredicate(boolean value);

}
