/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package nil.ucm.indications2.core.rep.problems;

import java.util.Collection;
import java.util.Collections;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IndicationStructureRep;

import org.eclipse.core.resources.IMarker;

import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class OverUsedTokensProblem extends StoryProblem {
	
	public static final String ID = "nil.ucm.indications2.core.problem.overusedTokens";
	
	public OverUsedTokensProblem(IDesc desc, String buildRuleID) {
		this(Collections.singleton(desc), buildRuleID);
	}

	public OverUsedTokensProblem(Collection<? extends IDesc> descs, String buildRuleID) {
		super(IndicationStructureRep.getInstance(), buildRuleID);
		setID(ID);
		setName("multiply-used tokens");
		setSeverity(IMarker.SEVERITY_ERROR);
		setRep(IndicationStructureRep.getInstance());
		setDescs(descs);
		IDescSet ds = getDescs().getDescriptions(IndicationStructureRep.getInstance());
		if(ds.isEmpty()) throw new IllegalArgumentException();
		setPosition(ds.first());

		StringBuilder sb = new StringBuilder();
		if(ds.size() == 1){
			IIndicationStructure is = (IIndicationStructure)ds.first().getData();
			sb.append("The indication '");
			sb.append(is.getReference().getDisplayText());
			sb.append("' uses at least one token in multiple constituents");
		} else {
			sb.append("There are ");
			sb.append(Integer.toString(ds.size()));
			sb.append(" indications that use at least one token in multiple constituents");
		}
		setDescription(sb.toString());
	}

}
