/* Filename: ArticlesAreDistinctive.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 2, 2010
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.problems.NuclearPersonalTitleProblem;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class PersonalTitlesAreUsuallyModifiersRule extends AbstractBuildRule {
	
	public static final String ID = PersonalTitlesAreUsuallyModifiersRule.class.getCanonicalName();
	
	public static final Set<String> titles = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(
			"mr", "mister", "mrs", 
			"miss", "mz", 
			"dr", "prof", "professor", 
			"president", "representative", "rep"
			)));

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public PersonalTitlesAreUsuallyModifiersRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		
		Set<String> titles = PersonalTitlesAreUsuallyModifiersRule.titles;
		
		Set<IDesc> problems = new HashSet<IDesc>();
		
		IIndicationStructure is;
		IToken token;
		String form;
		outer:for(IDesc desc : model.getData().getDescriptions(IndicationStructureRep.getInstance())){
			is = (IIndicationStructure)desc.getData();

			for(INucleus n : is.getNuclei()){
				for(ISegment s : n.getSegments()){
					for(IDesc d : s.getDescs()){
						token = (IToken)d.getData();
						form = token.getSurface().toLowerCase();
						if(form.endsWith(".")) form = form.substring(0, form.length()-1);
						if(titles.contains(form)){
							problems.add(desc);
							continue outer;
						}
					}
				}
			}
	
			// ignore titles in modifiers
//			for(IModifier m : is.getModifiers()){
//				
//				// if the modifier has only a single token, ignore,
//				// since if it is a title, it must be right
//				if(m.getSegments().size() == 1 && m.getSegments().first().getDescs().size() == 1) continue outer;
//				
//				for(ISegment s : m.getSegments()){
//					for(IDesc d : s.getDescs()){
//						token = (IToken)d.getData();
//						form = token.getSurface().toLowerCase();
//						if(form.endsWith(".")) form = form.substring(0, form.length()-1);
//						if(titles.contains(form)){
//							problems.add(desc);
//							continue outer;
//						}
//					}
//				}
//			}
			
		}

		// remove checked descriptions
		IDesc cd;
		IMetaDataSet<ICheck> checks;
		for(Iterator<IDesc> i = problems.iterator(); i.hasNext(); ) {
			cd = i.next();
			checks = cd.getMetaData().get(CheckMetaRep.getInstance());
			if(checks == null) continue;
			if(checks.contains(new MetaDesc<ICheck>(CheckMetaRep.getInstance(), cd, new Check(NuclearPersonalTitleProblem.ID))))
				i.remove();
		}
		
		// assemble problems
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		StoryProblem p;
		if(isCompressing()){
			if(!problems.isEmpty()){
				p = new NuclearPersonalTitleProblem(problems, ID);
				p.setCheck(NuclearPersonalTitleProblem.ID);
				result.add(p);
			}
		} else {
			for(IDesc problem : problems){
				p = new NuclearPersonalTitleProblem(problem, ID);
				p.setCheck(NuclearPersonalTitleProblem.ID);
				result.add(p);
			}
		}
		return result;
	}

}
