/* Filename: RefExp.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package edu.mit.discourse.core.rep.coref;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class Coref implements ICoref {
	
	private final String name;
	private final IDescSet refexps;
	
	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @param refexps
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public Coref(String name, Collection<? extends IDesc> refexps){
		name = name.trim();
		if(name.length() == 0)
			throw new IllegalArgumentException();
		this.name = name;
		
		IDescSet hidden = new DescSet(RefExpRep.getInstance());
		hidden.addAll(refexps);
		if(hidden.isEmpty())
			throw new IllegalArgumentException();
		this.refexps = new ImmutableDescSet(hidden);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.descriptor.IHasName#getName()
	 */
	public String getName() {
		return name;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.coref.ICoreference#getReferentialExpressions()
	 */
	public IDescSet getReferentialExpressions() {
		return refexps;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	public IHasPosition calculatePosition() {
		return refexps;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	public IHasPosition getDisplayPosition() {
		return refexps.first();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel)
	 */
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		
		IDescSet modelDescs = model.getData().getDescriptions(RefExpRep.getInstance());
		
		List<IDesc> newDescs = new LinkedList<IDesc>();
		IDesc newRefexp;
		boolean changed = false;
		for(IDesc oldRefexp : refexps){
			newRefexp = modelDescs.getDescription(oldRefexp.getID());
			
			// desc is gone
			if(newRefexp == null){
				changed = true;
				continue;
			}
			
			// desc is not the same
			if(newRefexp != oldRefexp)
				changed = true;
			
			newDescs.add(newRefexp);
		}
		
		// no referential expressions remain, delete it
		if(newDescs.isEmpty())
			return null;
		
		// no change, return original object
		if(!changed)
			return this;
		
		// make a new one
		return new Coref(name, newDescs);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	public int getLength() {
		return refexps.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	public int getOffset() {
		return refexps.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	public int getRightOffset() {
		return refexps.getRightOffset();
	}
	

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		
		if(!ICoref.class.isAssignableFrom(tgtData.getClass()))
			return false;
		
		ICoref tgtCoref = (ICoref)tgtData;
		
		if(!refexps.equals(tgtCoref.getReferentialExpressions(), model))
			return false;
		
		return true;
	}
	
}
