/* Filename: RefExpModel.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Aug 5, 2010
 */
package edu.mit.discourse.core.rep.refexp.models;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel;
import edu.mit.discourse.core.rep.refprops.model.ReferentPropertyModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.NotifyingHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class RefExpModel extends SegmentSetModel implements IRefExpModel {
	
	private IDesc loaded = null;
	private final MessageProviderManager manager = new MessageProviderManager();
	private IHasPositionSet<IReferentPropertyModel> properties = new NotifyingHasPositionSet<IReferentPropertyModel>(
		new INotifyCollectionCallback<IReferentPropertyModel>(){
			public void elementAdded(IReferentPropertyModel added) {
				manager.add(added);
				fireChanged();
			}
			public void elementRemoved(IReferentPropertyModel removed) {
				manager.remove(removed);
				fireChanged();
			}
		}
	);
	
	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param storyModel
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public RefExpModel(IStoryModel storyModel) {
		super(TokenRep.getInstance(), storyModel);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#internalClear()
	 */
	@Override
	protected void internalClear() {
		loaded = null;
		properties.clear();
		super.internalClear();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#isCleared()
	 */
	@Override
	public boolean isCleared() {
		if(loaded != null)
			return false;
		if(!properties.isEmpty())
			return false;
		return super.isCleared();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.helpers.models.IRefExpModel#create()
	 */
	public IRefExp create() {
		return new RefExp(getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.helpers.models.IRefExpModel#getLoaded()
	 */
	public IDesc getLoaded() {
		return loaded;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.helpers.models.IRefExpModel#load(edu.mit.story.core.desc.IDesc)
	 */
	public void load(IDesc desc) {
		if(!RefExpRep.getInstance().isType(desc))
			throw new IllegalArgumentException();
		internalClear();
		loaded = desc;
		
		IRefExp refexp = (IRefExp)desc.getData();
		setSegments(refexp.getSegments());
		
		if(getStoryModel().supports(RefPropRep.getInstance())){
			IDescSet propDescs = RefPropRep.collectProperties(refexp, getStoryModel());
			IReferentPropertyModel propModel;
			for(IDesc propDesc : propDescs){
				propModel = new ReferentPropertyModel(getStoryModel());
				propModel.load(propDesc);
				properties.add(propModel);
			}
		}
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refexp.models.IRefExpModel#getProperties()
	 */
	public IHasPositionSet<IReferentPropertyModel> getProperties() {
		return properties;
	}

}
