/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class LocalizationHelper {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    private static LocalizationHelper instance = new LocalizationHelper();

    public static String getLocaleString(String filename, String prefix) {
        String localeString = null;
        if (filename.startsWith(prefix) && filename.endsWith(PROPERTIES_FILE_EXTENSION)) {
            localeString = filename.length() > prefix.length() + PROPERTIES_FILE_EXTENSION.length() ? filename.substring(prefix.length() + 1, filename.length() - PROPERTIES_FILE_EXTENSION.length()) : "";
        }
        return localeString;
    }

    public static Locale getLocale(String localeString) {
        Locale locale = DEFAULT_LOCALE;
        if (localeString.length() == 5 && localeString.indexOf(95) == 2) {
            locale = new Locale(localeString.substring(0, 2), localeString.substring(3, 5));
        } else if (localeString.length() == 2) {
            locale = new Locale(localeString.substring(0, 2));
        }
        return locale;
    }

    public static Map getDirPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        File fullPath = new File(root, localizationPath);
        File localizationDir = fullPath.getParentFile();
        String localizationFile = fullPath.getName();
        String[] localizationFiles = LocalizationHelper.getLocalizationFiles(localizationDir, localizationFile);
        HashMap<Locale, Properties> localizations = null;
        if (localizationFiles != null) {
            localizations = new HashMap<Locale, Properties>(localizationFiles.length);
            int i = 0;
            while (i < localizationFiles.length) {
                String nextFile = localizationFiles[i];
                Locale nextLocale = LocalizationHelper.getLocale(LocalizationHelper.getLocaleString(nextFile, localizationFile));
                try {
                    Properties properties = LocalizationHelper.loadProperties(root, nextFile);
                    Properties localizedStrings = LocalizationHelper.getLocalizedProperties(propertyKeys, properties);
                    if (localizedStrings.size() > 0) {
                        localizations.put(nextLocale, localizedStrings);
                        if (DEFAULT_LOCALE.equals(nextLocale) && defaultLocale != null) {
                            localizations.put(nextLocale, localizedStrings);
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ++i;
            }
        }
        return localizations;
    }

    public static Map getJarPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        HashMap<Locale, Properties> localizations;
        block19: {
            ZipFile jarFile = null;
            localizations = new HashMap<Locale, Properties>(4);
            try {
                try {
                    jarFile = new ZipFile(root, 1);
                    Enumeration<? extends ZipEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry nextEntry = entries.nextElement();
                        String nextName = nextEntry.getName();
                        String localeString = LocalizationHelper.getLocaleString(nextName, localizationPath);
                        if (nextEntry.isDirectory() || localeString == null) continue;
                        Locale nextLocale = LocalizationHelper.getLocale(localeString);
                        InputStream stream = null;
                        try {
                            stream = jarFile.getInputStream(nextEntry);
                            Properties properties = new Properties();
                            properties.load(stream);
                            Properties localizedStrings = LocalizationHelper.getLocalizedProperties(propertyKeys, properties);
                            if (localizedStrings.size() <= 0) continue;
                            localizations.put(nextLocale, localizedStrings);
                            if (!DEFAULT_LOCALE.equals(nextLocale) || defaultLocale == null) continue;
                            localizations.put(nextLocale, localizedStrings);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return localizations;
    }

    private static Properties loadProperties(File root, String propertyFilename) throws IOException {
        Properties result = new Properties();
        InputStream propertyStream = null;
        try {
            try {
                if (root.isDirectory()) {
                    propertyStream = new FileInputStream(new File(root, propertyFilename));
                } else {
                    URLConnection connection = new URL("jar:" + root.toURL().toExternalForm() + "!/" + propertyFilename).openConnection();
                    connection.setUseCaches(false);
                    propertyStream = connection.getInputStream();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Properties properties = result;
                if (propertyStream != null) {
                    propertyStream.close();
                }
                return properties;
            }
            result.load(propertyStream);
        }
        finally {
            if (propertyStream != null) {
                propertyStream.close();
            }
        }
        return result;
    }

    public static Properties getLocalizedProperties(String[] propertyKeys, Properties properties) {
        Properties localizedProperties = new Properties();
        int i = 0;
        while (i < propertyKeys.length) {
            String localizedValue;
            String key = propertyKeys[i];
            if (key != null && (localizedValue = properties.getProperty(key)) != null) {
                localizedProperties.put(key, localizedValue);
            }
            ++i;
        }
        return localizedProperties;
    }

    public static String[] getLocalizationFiles(File localizationDir, final String filenamePrefix) {
        LocalizationHelper localizationHelper = instance;
        localizationHelper.getClass();
        return localizationDir.list(new FileFilter(localizationHelper){

            public boolean accept(File directory, String filename) {
                return LocalizationHelper.getLocaleString(filename, filenamePrefix) != null;
            }
        });
    }

    private LocalizationHelper() {
    }

    private abstract class FileFilter
    implements FilenameFilter {
        public abstract boolean accept(File var1, String var2);
    }
}

