/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.helpers;

import edu.mit.parsing.core.rep.sentence.model.ISentenceModel;
import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.parsing.ui.controllers.ISentenceController;
import edu.mit.parsing.ui.controllers.SentenceController;
import edu.mit.parsing.ui.widgets.SegmentCaptureWidget;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class SentenceCreatorPage
extends HelperPage
implements ChangeListener,
ICreatorPage {
    public static final String ID = SentenceCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Sentence";
    public static String actionLabelSave = "Save Sentence";
    public static String actionLabelClear = "Clear Sentence";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new sentence", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this sentence to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this sentence in the story model", 1);
    protected ISentenceController controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected SegmentCaptureWidget<ISegmentController> sentWidget;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public ISentenceController getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new SentenceController("edu.mit.story.ui.annotation.target1", this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputParent = new Composite(control, 0);
        inputParent.setBackground(control.getBackground());
        inputParent.setForeground(control.getForeground());
        inputParent.setLayoutData((Object)new GridData(4, 0, true, false));
        inputParent.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Expression");
        this.sentWidget = new SegmentCaptureWidget<ISentenceController>(inputParent, 65536, this.controller);
        this.sentWidget.setLayoutData(new GridData(4, 0, true, false, 4, 1));
        this.sentWidget.getCaptureAction().setText("Capture Sentence");
        this.sentWidget.getCaptureAction().setToolTipText("Capture Sentence");
        this.sentWidget.getClearAction().setText("Clear Sentence");
        this.sentWidget.getClearAction().setToolTipText("Clear Sentence");
        Composite buttonParent = new Composite(inputParent, 0);
        buttonParent.setBackground(inputParent.getBackground());
        buttonParent.setForeground(inputParent.getForeground());
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        label = new Label(buttonParent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setBackground(buttonParent.getBackground());
        label.setForeground(buttonParent.getForeground());
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                SentenceCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                SentenceCreatorPage.this.controller.clear();
            }
        };
        this.messageManager = new MessageProviderManager(createMessage, (ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.updateFromModel();
    }

    protected void updateFromModel() {
        IMessageProvider defaultMsg;
        ISentenceModel model = this.controller.getModel();
        boolean isLoaded = model.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        IMessageProvider iMessageProvider = defaultMsg = isLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        this.sentWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.sentWidget.getCaptureAction().getActionDefinitionId(), this.sentWidget.getCaptureAction());
        this.sentWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.sentWidget.getClearAction().getActionDefinitionId(), this.sentWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
    }

    public void stateChanged(ChangeEvent event) {
        this.updateFromModel();
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }
}

