/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.datamodel;

import com.google.common.base.Objects;
import edu.mit.story.core.datamodel.IStoryPairModel;
import edu.mit.story.core.datamodel.ResourcePairModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.ImmutableRepSet;
import edu.mit.story.core.validation.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.SortedSet;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryPairModel
extends ResourcePairModel
implements IStoryPairModel {
    public static final Message sourceNotSelected = new Message("Select a source file", 3);
    public static final Message sourceDoesNotExist = new Message("Source file does not exist", 3);
    public static final Message sourceUnparsable = new Message("The selected source is not a parsable story", 3);
    public static final Message targetNotSelected = new Message("Select a target file", 3);
    public static final Message targetDoesNotExist = new Message("Target file does not exist", 3);
    public static final Message targetUnparsable = new Message("The selected target is not a parsable story", 3);
    private IStoryModel sourceModel;
    private IStoryModel targetModel;
    private final SortedSet<IRep> emptySet = new ImmutableRepSet();

    @Override
    public boolean setSource(File file) {
        if (!Objects.equal((Object)file, (Object)this.getSourceFile())) {
            this.sourceModel = this.loadModel(file);
        }
        return super.setSource(file);
    }

    @Override
    public boolean setTarget(File file) {
        if (!Objects.equal((Object)file, (Object)this.getTargetFile())) {
            this.targetModel = this.loadModel(file);
        }
        return super.setTarget(file);
    }

    protected IStoryModel loadModel(File file) {
        if (file == null) {
            return null;
        }
        StoryModelImporter importer = new StoryModelImporter();
        importer.setResourceName(file.getAbsolutePath());
        try {
            return importer.importFromXML(new FileReader(file), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IStoryModel getSourceModel() {
        return this.sourceModel;
    }

    @Override
    public IStoryModel getTargetModel() {
        return this.targetModel;
    }

    @Override
    public SortedSet<IRep> getSupportedSource() {
        IStoryModel m = this.getSourceModel();
        if (m == null) {
            return this.emptySet;
        }
        return m.getSupported();
    }

    @Override
    public SortedSet<IRep> getSupportedTarget() {
        IStoryModel m = this.getTargetModel();
        if (m == null) {
            return this.emptySet;
        }
        return m.getSupported();
    }

    @Override
    protected void internalClear() {
        super.internalClear();
        this.sourceModel = null;
        this.targetModel = null;
    }

    @Override
    public boolean isCleared() {
        if (!super.isCleared()) {
            return false;
        }
        if (this.sourceModel != null) {
            return false;
        }
        return this.targetModel == null;
    }

    @Override
    protected IMessageProvider getSourceNotSelectedMessage() {
        return sourceNotSelected;
    }

    @Override
    protected IMessageProvider getTargetNotSelectedMessage() {
        return targetNotSelected;
    }

    @Override
    protected IMessageProvider getSourceDoesNotExistMessage() {
        return sourceDoesNotExist;
    }

    @Override
    protected IMessageProvider getTargetDoesNotExistMessage() {
        return targetDoesNotExist;
    }

    @Override
    protected IMessageProvider calculateMessage() {
        IMessageProvider result = super.calculateMessage();
        if (result != null) {
            return result;
        }
        if (this.sourceModel == null) {
            return sourceUnparsable;
        }
        if (this.targetModel == null) {
            return targetUnparsable;
        }
        return Message.NO_MESSAGE;
    }
}

