/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepresentationValueMapper
implements IValueMapper<IRep> {
    public static final String semicolon = ";";
    IRepManager fManager;

    public RepresentationValueMapper() {
        this(StoryPlugin.getDefault().getRepManager());
    }

    public RepresentationValueMapper(IRepManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.fManager = manager;
    }

    @Override
    public List<IRep> reconstitute(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("")) {
            return null;
        }
        String[] ids = value.split(semicolon);
        RepSet reps = new RepSet();
        int i = 0;
        while (i < ids.length) {
            IRep rep = this.getObject(ids[i]);
            if (rep == null) {
                return null;
            }
            reps.add(rep);
            ++i;
        }
        return new ArrayList<IRep>(reps);
    }

    @Override
    public String serialize(Collection<? extends IRep> reps) {
        if (reps == null) {
            return "";
        }
        if (reps.size() == 0) {
            return "";
        }
        RepSet repSet = new RepSet(reps);
        StringBuffer sb = new StringBuffer();
        Iterator i = repSet.iterator();
        while (i.hasNext()) {
            IRep rep = (IRep)i.next();
            sb.append(this.getValue(rep));
            if (!i.hasNext()) continue;
            sb.append(semicolon);
        }
        return sb.toString();
    }

    protected IRep getObject(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("")) {
            return null;
        }
        return this.fManager.getRep(value);
    }

    protected String getValue(IRep rep) {
        if (rep == null) {
            return "";
        }
        return rep.getID();
    }
}

