/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.SubstituteStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.RecalculateChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IRep;
import java.util.Iterator;
import java.util.LinkedList;

public class SubstituteDescChange
extends AbstractModelChange {
    private final IDesc substitute;
    private final IDesc target;

    public SubstituteDescChange(IDesc substitute, IDesc target) {
        super(StoryMessages.CHANGE_NAME_SubstituteDescription);
        if (substitute == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (substitute.getRep() != target.getRep()) {
            throw new IllegalArgumentException();
        }
        this.substitute = substitute;
        this.target = target;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        StoryChangeEvent removeEvent = new RemoveDescriptionsChange(this.target).apply(source, model);
        if (removeEvent == null) {
            return null;
        }
        LinkedList<IDesc> toRecalc = new LinkedList<IDesc>();
        IRep targetRep = this.substitute.getRep();
        Iterator<IDescSet> i = model.getData().descSetIterator();
        while (i.hasNext()) {
            IDescSet ds = i.next();
            if (!ds.getRep().getAntecedents().contains(targetRep) || !ds.getRep().isStructured()) continue;
            for (IDesc d : ds) {
                if (!PositionUtils.overlaps(d, this.target)) continue;
                toRecalc.add(d);
            }
        }
        SubstituteStoryModel substituteModel = new SubstituteStoryModel(this.substitute, this.target, model);
        StoryChangeEvent recalcEvent = new RecalculateChange(toRecalc).apply(source, substituteModel);
        StoryChangeEventIntegrator result = new StoryChangeEventIntegrator();
        result.addEvent(removeEvent);
        result.addEvent(recalcEvent);
        return result.asEvent();
    }
}

