/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyMapCallback;
import edu.mit.story.core.notify.NotifyingSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingMap<K, V>
extends AbstractMap<K, V> {
    protected final INotifyMapCallback<K, V> callback;
    protected final Map<K, V> backingMap;
    protected final Set<Map.Entry<K, V>> entrySet;
    protected final Set<K> keySet;

    public NotifyingMap(INotifyMapCallback<K, V> callback) {
        this(new HashMap(), callback);
    }

    public NotifyingMap(Map<K, V> backingMap, INotifyMapCallback<K, V> callback) {
        if (backingMap == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        NotifyingEntrySet<K, V> entrySet = new NotifyingEntrySet<K, V>(backingMap.entrySet(), callback);
        KeySet keySet = new KeySet();
        this.backingMap = backingMap;
        this.callback = callback;
        this.entrySet = entrySet;
        this.keySet = keySet;
    }

    protected void notifyAdd(K key, V value) {
        this.callback.mappingAdded(key, value);
    }

    protected void notifyModify(K key, V newValue, V oldValue) {
        this.callback.mappingModified(key, newValue, oldValue);
    }

    protected void notifyRemove(K key, V value) {
        this.callback.mappingRemoved(key, value);
    }

    @Override
    public V put(K key, V value) {
        boolean containsKey = this.backingMap.containsKey(key);
        V result = this.backingMap.put(key, value);
        if (containsKey) {
            if (result != value) {
                this.notifyModify(key, value, result);
            }
        } else {
            this.notifyAdd(key, value);
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        boolean containsKey = this.backingMap.containsKey(key);
        V value = this.backingMap.remove(key);
        if (containsKey) {
            this.notifyRemove(key, value);
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeySet
    extends AbstractSet<K> {
        @Override
        public int size() {
            return NotifyingMap.this.backingMap.keySet().size();
        }

        @Override
        public boolean contains(Object key) {
            return NotifyingMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            boolean result = this.contains(key);
            NotifyingMap.this.remove(key);
            return result;
        }

        @Override
        public Iterator<K> iterator() {
            return Iterators.transform(NotifyingMap.this.entrySet().iterator(), (Function)new Function<Map.Entry<K, V>, K>(){

                public K apply(Map.Entry<K, V> input) {
                    return input.getKey();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotifyMapToEntrySetCallback<K, V>
    implements INotifyCollectionCallback<Map.Entry<K, V>> {
        protected final INotifyMapCallback<K, V> callback;

        public NotifyMapToEntrySetCallback(INotifyMapCallback<K, V> callback) {
            if (callback == null) {
                throw new NullPointerException();
            }
            this.callback = callback;
        }

        @Override
        public void elementAdded(Map.Entry<K, V> added) {
            this.callback.mappingAdded(added.getKey(), added.getValue());
        }

        @Override
        public void elementRemoved(Map.Entry<K, V> removed) {
            this.callback.mappingRemoved(removed.getKey(), removed.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotifyingEntrySet<K, V>
    extends NotifyingSet<Map.Entry<K, V>> {
        protected final INotifyMapCallback<K, V> callback;

        public NotifyingEntrySet(Set<Map.Entry<K, V>> entrySet, INotifyMapCallback<K, V> callback) {
            super(entrySet, new NotifyMapToEntrySetCallback<K, V>(callback));
            this.callback = callback;
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new NotifyingEntrySetIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class NotifyingEntry
        implements Map.Entry<K, V> {
            protected final Map.Entry<K, V> backingEntry;

            public NotifyingEntry(Map.Entry<K, V> backingEntry) {
                if (backingEntry == null) {
                    throw new NullPointerException();
                }
                this.backingEntry = backingEntry;
            }

            @Override
            public V setValue(V value) {
                Object oldValue = this.backingEntry.getValue();
                this.backingEntry.setValue(value);
                NotifyingEntrySet.this.callback.mappingModified(this.backingEntry.getKey(), value, oldValue);
                return oldValue;
            }

            @Override
            public K getKey() {
                return this.backingEntry.getKey();
            }

            @Override
            public V getValue() {
                return this.backingEntry.getValue();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class NotifyingEntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            protected Iterator<Map.Entry<K, V>> backingItr;
            protected Map.Entry<K, V> last;

            public NotifyingEntrySetIterator() {
                this.backingItr = NotifyingEntrySet.this.backingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingItr.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = this.backingItr.next();
                this.last = new NotifyingEntry(next);
                return this.last;
            }

            @Override
            public void remove() {
                this.backingItr.remove();
                NotifyingEntrySet.this.callback.mappingRemoved(this.last.getKey(), this.last.getValue());
            }
        }
    }
}

