/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.HasPositionComparator;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionIterator<E extends IHasPosition>
implements Iterator<E> {
    private Iterator<? extends E> lastItr = null;
    private final Map<Iterator<? extends E>, E> itrMap;
    private final Comparator<IHasPosition> cmp = HasPositionComparator.getInstance();

    public PositionIterator(Collection<? extends IHasPositionSet<? extends E>> sets) {
        this.itrMap = new HashMap<Iterator<? extends E>, E>(sets.size());
        for (IHasPositionSet<E> set : sets) {
            this.itrMap.put(set.iterator(), null);
        }
    }

    public PositionIterator(IHasPositionSet<? extends E> ... sets) {
        this.itrMap = new HashMap<Iterator<? extends E>, E>(sets.length);
        IHasPositionSet<? extends E>[] iHasPositionSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IHasPositionSet<E> set = iHasPositionSetArray[n2];
            this.itrMap.put(set.iterator(), null);
            ++n2;
        }
    }

    @Override
    public boolean hasNext() {
        for (Map.Entry<Iterator<E>, E> entry : this.itrMap.entrySet()) {
            if (entry.getValue() != null) {
                return true;
            }
            if (!entry.getKey().hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        Map.Entry<Iterator<E>, E> first = null;
        for (Map.Entry<Iterator<E>, E> current : this.itrMap.entrySet()) {
            if (current.getValue() == null) {
                if (!current.getKey().hasNext()) continue;
                current.setValue((IHasPosition)current.getKey().next());
            }
            if (first == null) {
                first = current;
                continue;
            }
            if (this.cmp.compare((IHasPosition)first.getValue(), (IHasPosition)current.getValue()) <= 0) continue;
            first = current;
        }
        if (first == null) {
            throw new NoSuchElementException();
        }
        IHasPosition next = (IHasPosition)first.getValue();
        first.setValue(null);
        this.lastItr = first.getKey();
        return (E)next;
    }

    @Override
    public void remove() {
        if (this.lastItr == null) {
            throw new IllegalArgumentException();
        }
        this.lastItr.remove();
        this.lastItr = null;
    }
}

