/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.AbstractMapLabel;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.MapLabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.util.MapFactory;
import java.io.File;
import java.util.Comparator;
import java.util.TreeMap;

public class MapLabel
extends AbstractMapLabel {
    private static String printOptions = "value-index";
    private static final Comparator asStringComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private static final long serialVersionUID = 1289283452485202162L;

    public MapLabel() {
        this((String)null);
    }

    public MapLabel(MapFactory mapFactory) {
        this((String)null, mapFactory);
    }

    public MapLabel(String value) {
        this.setValue(value);
    }

    public MapLabel(String value, MapFactory mapFactory) {
        super(mapFactory);
        this.setValue(value);
    }

    public MapLabel(Label label) {
        this(label, MapFactory.HASH_MAP_FACTORY);
    }

    public MapLabel(Label label, MapFactory mapFactory) {
        super(mapFactory);
        if (label instanceof AbstractMapLabel) {
            AbstractMapLabel ml = (AbstractMapLabel)label;
            if (mapFactory == null) {
                this.mapFactory = ml.mapFactory;
                this.map = mapFactory.newMap(5);
            }
            this.map.putAll(ml.map());
        } else {
            this.map = mapFactory.newMap(5);
            if (label instanceof HasCategory) {
                this.map.put("cat", ((HasCategory)((Object)label)).category());
            }
            if (label instanceof HasTag) {
                this.setTag(((HasTag)((Object)label)).tag());
            }
            if (label instanceof HasWord) {
                this.map.put("word", ((HasWord)((Object)label)).word());
            }
        }
        this.setValue(label.value());
    }

    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    public String toString() {
        return this.toString(printOptions);
    }

    public String toString(String format) {
        StringBuilder buf = new StringBuilder();
        if (format.equals("value")) {
            buf.append(this.value());
        } else if (format.equals("{map}")) {
            TreeMap map2 = new TreeMap(asStringComparator);
            map2.putAll(this.map);
            buf.append(map2);
        } else if (format.equals("value{map}")) {
            buf.append(this.value());
            TreeMap map2 = new TreeMap(asStringComparator);
            map2.putAll(this.map);
            map2.remove("value");
            buf.append(map2);
        } else if (format.equals("value-index")) {
            buf.append(this.value());
            Object index = this.map.get("idx");
            if (index != null && index instanceof Integer) {
                buf.append("-").append((Integer)index);
            }
        } else if (format.equals("value-index{map}")) {
            buf.append(this.value());
            Object index = this.map.get("idx");
            if (index != null && index instanceof Integer) {
                buf.append("-").append((Integer)index);
            }
            TreeMap map2 = new TreeMap(asStringComparator);
            map2.putAll(this.map);
            map2.remove("idx");
            map2.remove("value");
            if (!map2.isEmpty()) {
                buf.append(map2);
            }
        } else if (format.equals("word")) {
            buf.append(this.word());
        }
        return buf.toString();
    }

    public static void setPrintOptions(String po) {
        printOptions = po;
    }

    public static void main(String[] args) {
        System.out.println("Testing different constructors");
        System.out.println("  MapLabel from zero-arg constructor:      " + new MapLabel());
        System.out.println("  MapLabel from String constructor:        " + new MapLabel("StringValue"));
        System.out.println("  MapLabel from Label constructor:         " + new MapLabel(new StringLabel("StringLabelValue")));
        System.out.println("  MapLabel from MapLabel constructor:      " + new MapLabel(new MapLabel("MapLabelValue")));
        MapLabel label = new MapLabel(new CategoryWordTag("cat", "word", "tag"));
        System.out.println("MapLabel from CategoryWordTag constructor: " + label);
        System.out.println("That same label in value{map} format:      " + label.toString("value{map}"));
        label.setIndex(666);
        System.out.println("Add index key 666 to that label:           " + label.toString("value{map}"));
        System.out.println("That label in {map} format:                " + label.toString("{map}"));
        System.out.println("That label in word format:                 " + label.toString("word"));
        System.out.println("That label in value-index format:          " + label.toString("value-index"));
        System.out.println("That label in value-index{map} format:     " + label.toString("value-index{map}"));
        int oldValue = label.index();
        label.setIndex(777);
        System.out.println("Changed the index from " + oldValue + ":                " + label.toString("value-index"));
        Object oldVal = label.put("idx", "sixsixsix");
        System.out.println("Changed the index from " + oldVal + " to string:      " + label.toString("value-index"));
        System.out.println("That label in value{map} format:           " + label.toString("value{map}"));
        label.map.remove("idx");
        System.out.println("Removed index key:                         " + label.toString("value-index"));
        System.out.println("That label in value{map} format:           " + label.toString("value{map}"));
        oldVal = label.put("foo", "bar");
        System.out.println("Changed foo from " + oldVal + ":                     " + label.toString("value-index{map}"));
        label.put("self", label);
        System.out.println("Add map entry with self as value:          " + label.toString("value-index{map}"));
        label.setHeadWord(new CategoryWordTag("cat", "rose", "tag"));
        System.out.println("Setting headWord to rose:                  " + label.toString("value{map}"));
        System.out.println("Testing serialization...");
        try {
            File testFile = IOUtils.writeObjectToTempFile(label, "testfile");
            MapLabel newLabel = (MapLabel)IOUtils.readObjectFromFile(testFile);
            System.out.println("New label:                                 " + newLabel.toString("value-index{map}"));
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.out.println("Done.");
    }

    private static class LabelFactoryHolder {
        static final LabelFactory lf = new MapLabelFactory();

        private LabelFactoryHolder() {
        }
    }
}

