/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

public final class SloppyMath {
    static final double LOGTOLERANCE = 30.0;
    static final float LOGTOLERANCE_F = 20.0f;

    public static int max(int a, int b, int c) {
        int ma = a;
        if (b > ma) {
            ma = b;
        }
        if (c > ma) {
            ma = c;
        }
        return ma;
    }

    public static int min(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public static float max(float a, float b) {
        return a >= b ? a : b;
    }

    public static double max(double a, double b) {
        return a >= b ? a : b;
    }

    public static float min(float a, float b) {
        return a <= b ? a : b;
    }

    public static double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static boolean isDangerous(double d) {
        return Double.isInfinite(d) || Double.isNaN(d) || d == 0.0;
    }

    public static boolean isVeryDangerous(double d) {
        return Double.isInfinite(d) || Double.isNaN(d);
    }

    public static boolean isCloseTo(double a, double b) {
        if (a > b) {
            return a - b < 1.0E-4;
        }
        return b - a < 1.0E-4;
    }

    public static float logAdd(float lx, float ly) {
        float negDiff;
        float max;
        if (lx > ly) {
            max = lx;
            negDiff = ly - lx;
        } else {
            max = ly;
            negDiff = lx - ly;
        }
        if ((double)max == Double.NEGATIVE_INFINITY) {
            return max;
        }
        if (negDiff < -20.0f) {
            return max;
        }
        return max + (float)Math.log(1.0 + Math.exp(negDiff));
    }

    public static double logAdd(double lx, double ly) {
        double negDiff;
        double max;
        if (lx > ly) {
            max = lx;
            negDiff = ly - lx;
        } else {
            max = ly;
            negDiff = lx - ly;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return max;
        }
        if (negDiff < -30.0) {
            return max;
        }
        return max + Math.log(1.0 + Math.exp(negDiff));
    }

    public static int nChooseK(int n, int k) {
        if ((k = Math.min(k, n - k)) == 0) {
            return 1;
        }
        int accum = n;
        int i = 1;
        while (i < k) {
            accum *= n - i;
            accum /= i;
            ++i;
        }
        return accum / k;
    }

    public static int intPow(int b, int e) {
        if (e == 0) {
            return 1;
        }
        int result = 1;
        int currPow = b;
        do {
            if ((e & 1) == 1) {
                result *= currPow;
            }
            currPow *= currPow;
        } while ((e >>= 1) > 0);
        return result;
    }

    public static float intPow(float b, int e) {
        if (e == 0) {
            return 1.0f;
        }
        float result = 1.0f;
        float currPow = b;
        do {
            if ((e & 1) == 1) {
                result *= currPow;
            }
            currPow *= currPow;
        } while ((e >>= 1) > 0);
        return result;
    }

    public static double intPow(double b, int e) {
        if (e == 0) {
            return 1.0;
        }
        float result = 1.0f;
        double currPow = b;
        do {
            if ((e & 1) == 1) {
                result = (float)((double)result * currPow);
            }
            currPow *= currPow;
        } while ((e >>= 1) > 0);
        return result;
    }

    public static double hypergeometric(int k, int n, int r, int m) {
        if (k < 0 || r > n || m > n || n <= 0 || m < 0 || r < 0) {
            throw new IllegalArgumentException("Invalid hypergeometric");
        }
        if (m > n / 2) {
            m = n - m;
            k = r - k;
        }
        if (r > n / 2) {
            r = n - r;
            k = m - k;
        }
        if (m > r) {
            int temp = m;
            m = r;
            r = temp;
        }
        if (k < m + r - n || k > m) {
            return 0.0;
        }
        if (r == n) {
            if (k == m) {
                return 1.0;
            }
            return 0.0;
        }
        if (r == n - 1) {
            if (k == m) {
                return (double)(n - m) / (double)n;
            }
            if (k == m - 1) {
                return (double)m / (double)n;
            }
            return 0.0;
        }
        if (m == 1) {
            if (k == 0) {
                return (double)(n - r) / (double)n;
            }
            if (k == 1) {
                return (double)r / (double)n;
            }
            return 0.0;
        }
        if (m == 0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k == 0) {
            double ans = 1.0;
            int m0 = 0;
            while (m0 < m) {
                ans *= (double)(n - r - m0);
                ans /= (double)(n - m0);
                ++m0;
            }
            return ans;
        }
        double ans = 1.0;
        int nr = n - r;
        int n0 = n;
        while (nr > n - r - (m - k)) {
            ans *= (double)nr;
            ans /= (double)n0;
            --nr;
            --n0;
        }
        int k0 = 0;
        while (k0 < k) {
            ans *= (double)(m - k0);
            ans /= (double)(n - (m - k0) + 1);
            ans *= (double)(r - k0);
            ans /= (double)(k0 + 1);
            ++k0;
        }
        return ans;
    }

    public static double exactBinomial(int k, int n, double p) {
        double total = 0.0;
        int m = k;
        while (m <= n) {
            double nChooseM = 1.0;
            int r = 1;
            while (r <= m) {
                nChooseM *= (double)(n - r + 1);
                nChooseM /= (double)r;
                ++r;
            }
            total += nChooseM * Math.pow(p, m) * Math.pow(1.0 - p, n - m);
            ++m;
        }
        return total;
    }

    public static double oneTailedFishersExact(int k, int n, int r, int m) {
        if (k < 0 || k < m + r - n || k > r || k > m || r > n || m > n) {
            throw new IllegalArgumentException("Invalid Fisher's exact: k=" + k + " n=" + n + " r=" + r + " m=" + m + " k<0=" + (k < 0) + " k<(m+r)-n=" + (k < m + r - n) + " k>r=" + (k > r) + " k>m=" + (k > m) + " r>n=" + (r > n) + "m>n=" + (m > n));
        }
        if (m > n / 2) {
            m = n - m;
            k = r - k;
        }
        if (r > n / 2) {
            r = n - r;
            k = m - k;
        }
        if (m > r) {
            int temp = m;
            m = r;
            r = temp;
        }
        double total = 0.0;
        if (k > m / 2) {
            int k0 = k;
            while (k0 <= m) {
                total += SloppyMath.hypergeometric(k0, n, r, m);
                ++k0;
            }
        } else {
            int min;
            int k0 = min = Math.max(0, m + r - n);
            while (k0 < k) {
                total += SloppyMath.hypergeometric(k0, n, r, m);
                ++k0;
            }
            total = 1.0 - total;
        }
        return total;
    }

    public static double chiSquare2by2(int k, int n, int r, int m) {
        int[][] cg = new int[][]{{k, r - k}, {m - k, n - (k + (r - k) + (m - k))}};
        int[] cgr = new int[]{r, n - r};
        int[] cgc = new int[]{m, n - m};
        double total = 0.0;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                double exp = (double)cgr[i] * (double)cgc[j] / (double)n;
                total += ((double)cg[i][j] - exp) * ((double)cg[i][j] - exp) / exp;
                ++j;
            }
            ++i;
        }
        return total;
    }

    public static double sigmoid(double x) {
        if (x < 0.0) {
            double num = Math.exp(x);
            return num / (1.0 + num);
        }
        double den = 1.0 + Math.exp(-x);
        return 1.0 / den;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java edu.stanford.nlp.math.SloppyMath [-logAdd|-fishers k n r m|-binomial r n p");
        } else if (args[0].equals("-logAdd")) {
            System.out.println("Log adds of neg infinity numbers, etc.");
            System.out.println("(logs) -Inf + -Inf = " + SloppyMath.logAdd(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
            System.out.println("(logs) -Inf + -7 = " + SloppyMath.logAdd(Double.NEGATIVE_INFINITY, -7.0));
            System.out.println("(logs) -7 + -Inf = " + SloppyMath.logAdd(-7.0, Double.NEGATIVE_INFINITY));
            System.out.println("(logs) -50 + -7 = " + SloppyMath.logAdd(-50.0, -7.0));
            System.out.println("(logs) -11 + -7 = " + SloppyMath.logAdd(-11.0, -7.0));
            System.out.println("(logs) -7 + -11 = " + SloppyMath.logAdd(-7.0, -11.0));
            System.out.println("real 1/2 + 1/2 = " + SloppyMath.logAdd(Math.log(0.5), Math.log(0.5)));
        } else if (args[0].equals("-fishers")) {
            int k = Integer.parseInt(args[1]);
            int n = Integer.parseInt(args[2]);
            int r = Integer.parseInt(args[3]);
            int m = Integer.parseInt(args[4]);
            double ans = SloppyMath.hypergeometric(k, n, r, m);
            System.out.println("hypg(" + k + "; " + n + ", " + r + ", " + m + ") = " + ans);
            ans = SloppyMath.oneTailedFishersExact(k, n, r, m);
            System.out.println("1-tailed Fisher's exact(" + k + "; " + n + ", " + r + ", " + m + ") = " + ans);
            double ansChi = SloppyMath.chiSquare2by2(k, n, r, m);
            System.out.println("chiSquare(" + k + "; " + n + ", " + r + ", " + m + ") = " + ansChi);
            System.out.println("Swapping arguments should give same hypg:");
            ans = SloppyMath.hypergeometric(k, n, r, m);
            System.out.println("hypg(" + k + "; " + n + ", " + m + ", " + r + ") = " + ans);
            int othrow = n - m;
            int othcol = n - r;
            int cell12 = m - k;
            int cell21 = r - k;
            int cell22 = othrow - (r - k);
            ans = SloppyMath.hypergeometric(cell12, n, othcol, m);
            System.out.println("hypg(" + cell12 + "; " + n + ", " + othcol + ", " + m + ") = " + ans);
            ans = SloppyMath.hypergeometric(cell21, n, r, othrow);
            System.out.println("hypg(" + cell21 + "; " + n + ", " + r + ", " + othrow + ") = " + ans);
            ans = SloppyMath.hypergeometric(cell22, n, othcol, othrow);
            System.out.println("hypg(" + cell22 + "; " + n + ", " + othcol + ", " + othrow + ") = " + ans);
        } else if (args[0].equals("-binomial")) {
            int k = Integer.parseInt(args[1]);
            int n = Integer.parseInt(args[2]);
            double p = Double.parseDouble(args[3]);
            double ans = SloppyMath.exactBinomial(k, n, p);
            System.out.println("Binomial p(X >= " + k + "; " + n + ", " + p + ") = " + ans);
        } else {
            System.err.println("Unknown option: " + args[0]);
        }
    }
}

