/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.regex.Pattern;

public class XMLBeginEndIterator
extends AbstractIterator {
    private Pattern tagNamePattern;
    private BufferedReader in;
    private Object nextToken;
    private Function op;
    private boolean keepInternalTags;
    private boolean keepDelimitingTags;

    public XMLBeginEndIterator(Reader in, String tagNameRegexp) {
        this(in, tagNameRegexp, new IdentityFunction(), false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function op, boolean keepInternalTags) {
        this(in, tagNameRegexp, op, keepInternalTags, false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags, boolean keepDelimitingTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags, keepDelimitingTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function op, boolean keepInternalTags, boolean keepDelimitingTags) {
        this.tagNamePattern = Pattern.compile(tagNameRegexp);
        this.op = op;
        this.keepInternalTags = keepInternalTags;
        this.keepDelimitingTags = keepDelimitingTags;
        this.in = new BufferedReader(in);
        this.setNext();
    }

    private void setNext() {
        String s = this.getNext();
        this.nextToken = this.parseString(s);
    }

    private String getNext() {
        StringBuilder result = new StringBuilder();
        try {
            String text;
            XMLUtils.XMLTag tag;
            do {
                text = XMLUtils.readUntilTag(this.in);
                tag = XMLUtils.readAndParseTag(this.in);
                if (tag != null) continue;
                return null;
            } while (!this.tagNamePattern.matcher(tag.name).matches() || tag.isEndTag);
            if (this.keepDelimitingTags) {
                result.append(tag.toString());
            }
            while (true) {
                String tagString;
                if ((text = XMLUtils.readUntilTag(this.in)) != null) {
                    result.append(text);
                }
                if ((tag = XMLUtils.parseTag(tagString = XMLUtils.readTag(this.in))) == null) {
                    return null;
                }
                if (this.tagNamePattern.matcher(tag.name).matches() && tag.isEndTag) {
                    if (this.keepDelimitingTags) {
                        result.append(tagString);
                    }
                    break;
                }
                if (!this.keepInternalTags) continue;
                result.append(tagString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    protected Object parseString(String s) {
        return this.op.apply(s);
    }

    public boolean hasNext() {
        return this.nextToken != null;
    }

    public Object next() {
        Object token = this.nextToken;
        this.setNext();
        return token;
    }

    public Object peek() {
        return this.nextToken;
    }

    public static IteratorFromReaderFactory getFactory(String tag) {
        return new XMLBeginEndIteratorFactory(tag, new IdentityFunction(), false, false);
    }

    public static IteratorFromReaderFactory getFactory(String tag, Function op) {
        return new XMLBeginEndIteratorFactory(tag, op, false, false);
    }

    public static IteratorFromReaderFactory getFactory(String tag, Function op, boolean keepInternalTags, boolean keepDelimitingTags) {
        return new XMLBeginEndIteratorFactory(tag, op, keepInternalTags, keepDelimitingTags);
    }

    public static void main(String[] args) throws Exception {
        FileReader in = new FileReader(args[0]);
        XMLBeginEndIterator iter = new XMLBeginEndIterator(in, args[1], args[2].equalsIgnoreCase("true"));
        int i = 0;
        while (iter.hasNext()) {
            String s = (String)iter.next();
            ++i;
            System.out.println("*************************************************");
            System.out.println(s);
        }
    }

    static class XMLBeginEndIteratorFactory
    implements IteratorFromReaderFactory {
        private String tag;
        private Function op;
        private boolean keepInternalTags;
        private boolean keepDelimitingTags;

        public XMLBeginEndIteratorFactory(String tag, Function op, boolean keepInternalTags, boolean keepDelimitingTags) {
            this.tag = tag;
            this.op = op;
            this.keepInternalTags = keepInternalTags;
            this.keepDelimitingTags = keepDelimitingTags;
        }

        public Iterator getIterator(Reader r) {
            return new XMLBeginEndIterator(r, this.tag, this.op, this.keepInternalTags, this.keepDelimitingTags);
        }
    }
}

