/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.GermanLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.NegraPennCollinizer;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraHeadFinder;
import edu.stanford.nlp.trees.international.negra.NegraLabel;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennTokenizer;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeNormalizer;
import java.io.Reader;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NegraPennTreebankParserParams
extends AbstractTreebankParserParams {
    private static final boolean DEBUG = false;
    public static boolean markRC = false;
    public static boolean markZuVP = false;
    private NegraPennLanguagePack nplp = (NegraPennLanguagePack)this.treebankLanguagePack();
    private NegraPennTreeReaderFactory treeReaderFactory = new NegraPennTreeReaderFactory();
    private static final long serialVersionUID = 2L;

    public NegraPennTreebankParserParams() {
        super(new NegraPennLanguagePack());
        this.setInputEncoding(this.tlp.getEncoding());
        this.setOutputEncoding(this.tlp.getEncoding());
    }

    public HeadFinder headFinder() {
        return new NegraHeadFinder();
    }

    public Lexicon lex(Options.LexOptions op) {
        return new GermanLexicon(op);
    }

    public TreeReaderFactory treeReaderFactory() {
        return this.treeReaderFactory;
    }

    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory, this.inputEncoding);
    }

    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory, this.inputEncoding);
    }

    public TreeTransformer collinizer() {
        return new NegraPennCollinizer();
    }

    public TreeTransformer collinizerEvalb() {
        return new NegraPennCollinizer(false);
    }

    public TreebankLanguagePack treebankLanguagePack() {
        return new NegraPennLanguagePack();
    }

    public String[] sisterSplitters() {
        return new String[0];
    }

    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-leaveGF")) {
            this.treeReaderFactory.treeNormalizerLeaveGF = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markZuVP")) {
            markZuVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markRC")) {
            markRC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-insertNPinPP")) {
            this.treeReaderFactory.treeNormalizerInsertNPinPP = true;
            ++i;
        }
        return i;
    }

    public void display() {
        System.out.println("markZuVP=" + markZuVP);
        System.out.println("insertNPinPP=" + this.treeReaderFactory.treeNormalizerInsertNPinPP);
        System.out.println("leaveGF=" + this.treeReaderFactory.treeNormalizerLeaveGF);
    }

    private String basicCat(String str) {
        return this.nplp.basicCategory(str);
    }

    public Tree transformTree(Tree t, Tree root) {
        if (t == null || t.isLeaf()) {
            return t;
        }
        HashSet<String> annotations = new HashSet<String>();
        CategoryWordTag lab = (CategoryWordTag)t.label();
        String word = lab.word();
        String tag = lab.tag();
        String baseTag = this.nplp.basicCategory(tag);
        String cat = lab.value();
        String baseCat = this.nplp.basicCategory(cat);
        if (t.isPhrasal()) {
            List childBasicCats = this.childBasicCats(t);
            if (markZuVP && baseCat.equals("VP") && (childBasicCats.contains("VZ") || childBasicCats.contains("VVIZU"))) {
                annotations.add("-ZU");
            }
            if (markRC && t.label() instanceof NegraLabel && baseCat.equals("S") && ((NegraLabel)t.label()).getEdge() != null && ((NegraLabel)t.label()).getEdge().equals("RC")) {
                annotations.add("-RC");
            }
        }
        Iterator i = annotations.iterator();
        while (i.hasNext()) {
            cat = cat + (String)i.next();
        }
        t.setLabel(new CategoryWordTag(cat, word, tag));
        return t;
    }

    private List childBasicCats(Tree t) {
        Tree[] kids = t.children();
        ArrayList<String> l = new ArrayList<String>();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            l.add(this.basicCat(kids[i].label().value()));
        }
        return l;
    }

    public List defaultTestSentence() {
        return Arrays.asList("Solch", "einen", "Zuspruch", "hat", "Angela", "Merkel", "lange", "nicht", "mehr", "erlebt", ".");
    }

    public static void main(String[] args) {
        NegraPennTreebankParserParams tlpp = new NegraPennTreebankParserParams();
        MemoryTreebank tb = tlpp.memoryTreebank();
        tb.loadPath(args[0]);
        Iterator i = ((AbstractCollection)tb).iterator();
        while (i.hasNext()) {
            ((Tree)i.next()).pennPrint();
        }
    }

    private static class NegraPennTreeReaderFactory
    implements TreeReaderFactory,
    Serializable {
        boolean treeNormalizerInsertNPinPP = false;
        boolean treeNormalizerLeaveGF = false;

        private NegraPennTreeReaderFactory() {
        }

        public TreeReader newTreeReader(Reader in) {
            NegraPennTreeNormalizer tn = new NegraPennTreeNormalizer();
            if (this.treeNormalizerLeaveGF) {
                tn.setLeaveGF(true);
            }
            if (this.treeNormalizerInsertNPinPP) {
                tn.setInsertNPinPP(true);
            }
            return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), tn, new NegraPennTokenizer(in));
        }
    }
}

