/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.History;
import java.util.HashMap;

public class HistoryTable {
    private HashMap vHI;
    private HashMap vIH;
    private int capacity = 300000;

    public HistoryTable() {
        this.vHI = new HashMap(this.capacity);
        this.vIH = new HashMap(this.capacity);
    }

    public void release() {
        this.vHI.clear();
        this.vIH.clear();
    }

    public HistoryTable(int capacity) {
        this.capacity = capacity;
        this.vHI = new HashMap(capacity);
        this.vIH = new HashMap(capacity);
    }

    public int add(History h) {
        if (this.vHI.containsKey(h)) {
            return (Integer)this.vHI.get(h);
        }
        Integer iO = new Integer(this.vHI.size());
        this.vHI.put(h, iO);
        this.vIH.put(iO, h);
        return iO;
    }

    public int put(History h) {
        Integer iO = new Integer(this.vHI.size());
        this.vHI.put(h, iO);
        this.vIH.put(iO, h);
        return iO;
    }

    public History getHistory(int index) {
        Integer iO = new Integer(index);
        return (History)this.vIH.get(iO);
    }

    public int getIndex(History h) {
        try {
            if (this.vHI.containsKey(h)) {
                return (Integer)this.vHI.get(h);
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean contains(History h) {
        return this.vHI.containsKey(h);
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            int s = this.vIH.size();
            rf.writeInt(s);
            int i = 0;
            while (i < s) {
                History v0 = this.getHistory(i);
                v0.save(rf);
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            int s = rf.readInt();
            int i = 0;
            while (i < s) {
                History v0 = new History();
                v0.read(rf);
                this.put(v0);
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new HistoryTable();
    }
}

