/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TreeMatcher;
import edu.stanford.nlp.trees.tregex.TreePattern;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TregexMatcher {
    final Tree root;
    Tree tree;
    Map<Object, Tree> namesToNodes;
    VariableStrings variableStrings;
    Iterator findIterator;
    Tree findCurrent;

    TregexMatcher(Tree root, Tree tree, Map<Object, Tree> namesToNodes, VariableStrings variableStrings) {
        this.root = root;
        this.tree = tree;
        this.namesToNodes = namesToNodes;
        this.variableStrings = variableStrings;
    }

    public void reset() {
        this.findIterator = null;
        this.namesToNodes.clear();
    }

    void resetChildIter(Tree tree) {
        this.tree = tree;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(Tree node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract Tree getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            this.findIterator = this.root.iterator();
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = (Tree)this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findNextMatchingNode() {
        Tree lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public Tree getNode(Object name) {
        return this.namesToNodes.get(name);
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put("-p", new Integer(1));
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        String s = "VP < VBZ";
        if (argsMap.keySet().contains("-p")) {
            s = argsMap.get("-p")[0];
        }
        TregexPattern tregexPattern = TregexPattern.compile(s);
        EnglishTreebankParserParams tlpp = new EnglishTreebankParserParams();
        NumberRangesFileFilter testFilt = new NumberRangesFileFilter(args[1], true);
        DiskTreebank testTreebank = tlpp.diskTreebank();
        testTreebank.loadPath(new File(args[0]), (FileFilter)testFilt);
        TreePattern treePattern = null;
        boolean print = argsMap.keySet().contains("-print");
        for (Tree root : testTreebank) {
            TregexMatcher tregexMatcher = tregexPattern.matcher(root);
            TreeMatcher treeMatcher = treePattern.matcher(root);
            Tree lastTreeMatch = null;
            ArrayList<Tree> tregexMatchedTrees = new ArrayList<Tree>();
            ArrayList<Tree> treeMatchedTrees = new ArrayList<Tree>();
            while (treeMatcher.find()) {
                Tree treeMatchedTree = treeMatcher.getMatch();
                if (treeMatchedTree == lastTreeMatch) continue;
                treeMatchedTrees.add(treeMatchedTree);
                lastTreeMatch = treeMatchedTree;
            }
            while (tregexMatcher.find()) {
                Tree tregexMatchedTree = tregexMatcher.getMatch();
                tregexMatchedTrees.add(tregexMatchedTree);
            }
            if (((Object)tregexMatchedTrees).equals(treeMatchedTrees)) continue;
            System.out.println("Disagreement");
            if (!print) continue;
            System.out.println("TreeMatcher found " + treeMatchedTrees.size() + " matches:");
            for (Tree tree : treeMatchedTrees) {
                tree.pennPrint();
            }
            System.out.println("TregexMatcher found " + tregexMatchedTrees.size() + " matches:");
            for (Tree tree : tregexMatchedTrees) {
                tree.pennPrint();
            }
        }
    }
}

