/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.ChangeSupport;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractObservableMap
extends AbstractMap
implements IObservableMap {
    private ChangeSupport changeSupport;
    private boolean stale;

    public AbstractObservableMap() {
        this(Realm.getDefault());
    }

    protected void lastListenerRemoved() {
    }

    protected void firstListenerAdded() {
    }

    public AbstractObservableMap(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        this.changeSupport = new ChangeSupport(realm){

            protected void firstListenerAdded() {
                AbstractObservableMap.this.firstListenerAdded();
            }

            protected void lastListenerRemoved() {
                AbstractObservableMap.this.lastListenerRemoved();
            }
        };
    }

    public synchronized void addMapChangeListener(IMapChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.addListener(MapChangeEvent.TYPE, listener);
        }
    }

    public synchronized void removeMapChangeListener(IMapChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removeListener(MapChangeEvent.TYPE, listener);
        }
    }

    public synchronized void addChangeListener(IChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.addChangeListener(listener);
        }
    }

    public synchronized void addStaleListener(IStaleListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.addStaleListener(listener);
        }
    }

    public synchronized void dispose() {
        if (this.changeSupport != null) {
            this.changeSupport.dispose();
            this.changeSupport = null;
        }
    }

    public Realm getRealm() {
        if (this.changeSupport != null) {
            return this.changeSupport.getRealm();
        }
        return null;
    }

    public boolean isStale() {
        this.checkRealm();
        return this.stale;
    }

    public synchronized void removeChangeListener(IChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(listener);
        }
    }

    public synchronized void removeStaleListener(IStaleListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removeStaleListener(listener);
        }
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        this.stale = stale;
        if (stale) {
            this.fireStale();
        }
    }

    protected void fireStale() {
        this.checkRealm();
        this.changeSupport.fireEvent(new StaleEvent(this));
    }

    protected void fireChange() {
        this.checkRealm();
        this.changeSupport.fireEvent(new ChangeEvent(this));
    }

    protected void fireMapChange(MapDiff diff) {
        this.checkRealm();
        this.changeSupport.fireEvent(new MapChangeEvent(this, diff));
    }

    protected void checkRealm() {
        Assert.isTrue((boolean)this.getRealm().isCurrent(), (String)"This operation must be run within the observable's realm");
    }
}

