/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class TopicFinder {
    private ITopic[] foundTopicPath;
    private int selectedToc;
    private IToc[] tocs;
    private String numericPath = null;

    public TopicFinder(String topicHref, IToc[] tocs) {
        this.tocs = tocs;
        if (topicHref != null && topicHref.length() > 0) {
            int index = -1;
            do {
                this.selectedToc = this.findTocContainingTopic(topicHref);
                ITopic topic = this.findTopic(UrlUtil.getHelpURL(topicHref));
                if (topic != null && this.selectedToc >= 0) {
                    this.foundTopicPath = this.getTopicPathInToc(topic, tocs[this.selectedToc]);
                }
                if (this.foundTopicPath != null || topicHref == null || (index = topicHref.indexOf(35)) == -1) continue;
                topicHref = topicHref.substring(0, index);
            } while (this.foundTopicPath == null && index != -1);
        } else {
            this.selectedToc = -1;
            this.foundTopicPath = null;
        }
    }

    public ITopic[] getTopicPath() {
        return this.foundTopicPath;
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getNumericPath() {
        return this.numericPath;
    }

    private ITopic[] getTopicPathInToc(ITopic topicToFind, IToc toc) {
        if (topicToFind.getLabel().equals(toc.getLabel())) {
            return new ITopic[0];
        }
        ITopic[] topics = toc.getTopics();
        if (topics != null) {
            int i = 0;
            while (i < topics.length) {
                List reversePath = this.getTopicPathInTopic(topicToFind, topics[i]);
                if (reversePath != null) {
                    this.appendFilteredIndex(i, topics);
                    return this.invertPath(reversePath);
                }
                ++i;
            }
        }
        return null;
    }

    private ITopic[] invertPath(List reversePath) {
        ITopic[] path = new ITopic[reversePath.size()];
        int j = 0;
        while (j < path.length) {
            path[j] = (ITopic)reversePath.get(path.length - 1 - j);
            ++j;
        }
        return path;
    }

    private boolean sameTopic(ITopic topicToFind, ITopic topic) {
        if (!topic.getLabel().equals(topicToFind.getLabel())) {
            return false;
        }
        if (topicToFind.getHref() == null) {
            return topic.getHref() == null;
        }
        return topicToFind.getHref().equals(topic.getHref());
    }

    private List getTopicPathInTopic(ITopic topicToFind, ITopic topic) {
        if (this.sameTopic(topicToFind, topic)) {
            ArrayList<ITopic> path = new ArrayList<ITopic>();
            path.add(topic);
            return path;
        }
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            List path = this.getTopicPathInTopic(topicToFind, subtopics[i]);
            if (path != null) {
                path.add(topic);
                this.appendFilteredIndex(i, subtopics);
                return path;
            }
            ++i;
        }
        return null;
    }

    private void appendFilteredIndex(int indexInUnfilteredList, ITopic[] unfiltered) {
        int indexInFilteredList = 0;
        int i = 0;
        while (i < indexInUnfilteredList) {
            if (EnabledTopicUtils.isEnabled(unfiltered[i])) {
                ++indexInFilteredList;
            }
            ++i;
        }
        this.numericPath = this.numericPath == null ? "" + indexInFilteredList : "" + indexInFilteredList + '_' + this.numericPath;
    }

    private int findTocContainingTopic(String topic) {
        if (topic == null || topic.equals("")) {
            return -1;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        } else {
            index = topic.indexOf("/nav/");
            if (index != -1) {
                String nav = topic.substring(index + 5);
                String book = (index = nav.indexOf(95)) == -1 ? nav : nav.substring(0, index);
                try {
                    return Integer.parseInt(book);
                }
                catch (Exception exception) {}
            }
        }
        index = topic.indexOf(63);
        if (index != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return -1;
        }
        int i = 0;
        while (i < this.tocs.length) {
            if (this.isEnabled(this.tocs[i])) {
                if (this.tocs[i].getTopic(topic) != null) {
                    return i;
                }
                ITopic tocTopic = this.tocs[i].getTopic(null);
                if (tocTopic != null && topic.equals(tocTopic.getHref())) {
                    return i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.tocs.length) {
            if (!this.isEnabled(this.tocs[i]) && this.tocs[i].getTopic(topic) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ITopic findTopic(String topic) {
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        } else {
            index = topic.indexOf("/nav/");
            if (index != -1) {
                String nav = topic.substring(index + 5);
                StringTokenizer tok = new StringTokenizer(nav, "_");
                try {
                    index = Integer.parseInt(tok.nextToken());
                    ITopic current = this.tocs[index].getTopic(null);
                    while (tok.hasMoreTokens()) {
                        index = Integer.parseInt(tok.nextToken());
                        current = current.getSubtopics()[index];
                    }
                    return current;
                }
                catch (Exception exception) {}
            }
        }
        index = topic.indexOf(63);
        if (index != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return null;
        }
        if (this.selectedToc < 0) {
            return null;
        }
        IToc selectedToc2 = this.tocs[this.selectedToc];
        if (selectedToc2 == null) {
            return null;
        }
        ITopic selectedTopic = selectedToc2.getTopic(topic);
        if (selectedTopic != null) {
            return selectedTopic;
        }
        ITopic tocTopic = selectedToc2.getTopic(null);
        if (tocTopic != null && topic.equals(tocTopic.getHref())) {
            return tocTopic;
        }
        return null;
    }

    private boolean isEnabled(IToc toc) {
        boolean tocEnabled;
        boolean bl = tocEnabled = HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref()) && !UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext());
        if (!tocEnabled) {
            return false;
        }
        ITopic[] topics = toc.getTopics();
        int i = 0;
        while (i < topics.length) {
            if (EnabledTopicUtils.isEnabled(topics[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

