/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.RefPair;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ReferentLabelProvider
extends StoryModelLabelProvider {
    public ReferentLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof RefPair) {
            RefPair ref = (RefPair)element;
            StyledString s = new StyledString(ref.ref.getDisplayText());
            int offset = s.length();
            s.append(" - ");
            IReferent r = (IReferent)ref.desc.getData();
            s.append(r.getName());
            s.append(" (");
            s.append(Long.toString(ref.desc.getID()));
            s.append('-');
            s.append(Long.toString(ref.ref.getID()));
            s.append(')');
            s.setStyle(offset, s.length() - offset, StyledString.DECORATIONS_STYLER);
            return s;
        }
        if (element instanceof IDesc && ReferentRep.getInstance().isType((IHasRep)element)) {
            IDesc desc = (IDesc)element;
            IReferent ref = (IReferent)desc.getData();
            StyledString s = new StyledString(ref.getName());
            s.append(" (" + Long.toString(desc.getID()) + ')', StyledString.DECORATIONS_STYLER);
            return s;
        }
        if (element instanceof IReferent) {
            IReferent ref = (IReferent)element;
            return new StyledString(ref.getName());
        }
        if (element instanceof IReference) {
            IReference ref = (IReference)element;
            StyledString s = new StyledString(ref.getDisplayText());
            s.append(' ');
            s.append(String.valueOf('(') + Long.toString(ref.getID()) + ')', StyledString.DECORATIONS_STYLER);
            return s;
        }
        if (element instanceof Object[]) {
            return new StyledString("(properties)", StyledString.COUNTER_STYLER);
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && ReferentRep.getInstance().isType((IHasRep)element)) {
            element = ((IDesc)element).getData();
        }
        if (element instanceof IReferent) {
            return DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/referent.gif");
        }
        if (element instanceof IReference || element instanceof RefPair) {
            return DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/reference.gif");
        }
        if (element instanceof Object[]) {
            return DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/properties.gif");
        }
        if (element instanceof IDesc && RefPropRep.getInstance().isType((IHasRep)element)) {
            element = ((IDesc)element).getData();
        }
        if (element instanceof IReferentProperty) {
            return DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/property.gif");
        }
        return super.getImage(element);
    }
}

