/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.views;

import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorHighlighter;
import java.util.WeakHashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceHighlighter
extends StoryEditorHighlighter<IStoryEditor>
implements IModelListener {
    private static final WeakHashMap<IStoryEditor, ReferenceHighlighter> map = new WeakHashMap();
    private IDesc refDesc;

    public static ReferenceHighlighter getHighlighter(final IStoryEditor editor) {
        if (editor == null || editor.isDisposed()) {
            return null;
        }
        ReferenceHighlighter h = map.get(editor);
        if (h != null) {
            return h;
        }
        final ReferenceHighlighter hl = new ReferenceHighlighter(editor);
        editor.getTextViewer().getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                map.remove(editor);
                hl.dispose();
            }
        });
        map.put(editor, hl);
        return hl;
    }

    public boolean setHighlightedReferent(IDesc newDesc) {
        if (this.refDesc == newDesc) {
            return false;
        }
        if (!ReferentRep.getInstance().isType((IHasRep)newDesc)) {
            return false;
        }
        this.refDesc = newDesc;
        this.refreshHighlighting();
        return true;
    }

    public IDesc getHighlightedReferent() {
        return this.refDesc;
    }

    protected ReferenceHighlighter(IStoryEditor targetEditor) {
        super(targetEditor, "edu.mit.story.ui.annotation.target0", DiscourseUIMessages.ANNOTATION_Reference_message);
        this.getEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    protected IHasPositionSet<? extends IHasPosition> getAnnotationPositions() {
        if (this.refDesc == null) {
            return null;
        }
        IReferent ref = (IReferent)this.refDesc.getData();
        return ref.getReferences();
    }

    public void modelChanged(StoryChangeEvent e) {
        if (e.affects(ReferentRep.getInstance())) {
            this.refreshHighlighting();
        }
    }
}

