/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.viewers;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryTreeContentManager;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryTreeListener;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DeferredQueryContentProvider
implements ITreeContentProvider {
    DeferredQueryTreeContentManager manager;
    IQueryProvider queryProvider;
    Object currentInput;
    HashMap alreadyQueried = new HashMap();
    HashSet queryCompleted = new HashSet();
    AbstractTreeViewer viewer = null;
    ListenerList listeners = new ListenerList();
    boolean synchronous = false;

    public DeferredQueryContentProvider(IQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void addListener(DeferredQueryContentListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(DeferredQueryContentListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (this.manager != null) {
            this.manager.cancel(oldInput);
        }
        if (v instanceof AbstractTreeViewer) {
            this.manager = new DeferredQueryTreeContentManager((AbstractTreeViewer)v);
            this.viewer = (AbstractTreeViewer)v;
            this.manager.setListener(new DeferredQueryTreeListener(){

                public void fetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.alreadyQueried.put(parent, placeholder);
                }

                public void finishedFetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.queryCompleted.add(parent);
                }
            });
        } else {
            this.viewer = null;
        }
        this.alreadyQueried = new HashMap();
        this.queryCompleted = new HashSet();
        this.currentInput = newInput;
        Object[] inputListeners = this.listeners.getListeners();
        int i = 0;
        while (i < inputListeners.length) {
            ((DeferredQueryContentListener)inputListeners[i]).inputChanged(v, oldInput, newInput);
            ++i;
        }
    }

    public Object[] getElements(Object input) {
        if (input instanceof QueriedElement) {
            QueriedElement element = (QueriedElement)input;
            element.setQueryProvider(this.queryProvider);
            return this.getChildren(element);
        }
        return null;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
    }

    public Object getParent(Object child) {
        if (child instanceof ProvElement) {
            return ((ProvElement)child).getParent(child);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        if (element instanceof ProvElement) {
            return ((ProvElement)element).hasChildren(element);
        }
        return false;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof RemoteQueriedElement) {
            RemoteQueriedElement element = (RemoteQueriedElement)parent;
            if (element.hasQueryable()) {
                return element.getChildren(element);
            }
            if (this.manager != null && !this.synchronous) {
                return this.manager.getChildren(parent);
            }
        }
        if (parent instanceof ProvElement) {
            return ((ProvElement)parent).getChildren(parent);
        }
        return null;
    }

    public void setSynchronous(boolean sync) {
        if (sync && this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
        this.synchronous = sync;
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }
}

