/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.osgi.framework.Bundle;

public final class BusyIndicator
extends Canvas {
    private static final int MARGIN = 0;
    private static final int IMAGE_COUNT = 8;
    private static final int MILLISECONDS_OF_DELAY = 180;
    private Image[] imageCache;
    protected Image image;
    protected Image animationImage;
    protected BusyThread busyThread;

    public BusyIndicator(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BusyIndicator.this.onPaint(event);
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        if (this.image != null) {
            Rectangle ibounds = this.image.getBounds();
            size.x = ibounds.width;
            size.y = ibounds.height;
        }
        if (this.isBusy()) {
            Rectangle bounds = this.getImage(0).getBounds();
            size.x = Math.max(size.x, bounds.width);
            size.y = Math.max(size.y, bounds.height);
        }
        size.x += 0;
        size.y += 0;
        return size;
    }

    public boolean forceFocus() {
        return false;
    }

    protected synchronized void createBusyThread() {
        if (this.busyThread != null) {
            return;
        }
        Rectangle bounds = this.getImage(0).getBounds();
        Display display = this.getDisplay();
        Image offScreenImage = new Image((Device)display, bounds.width, bounds.height);
        GC offScreenImageGC = new GC((Drawable)offScreenImage);
        this.busyThread = new BusyThread(bounds, display, offScreenImageGC, offScreenImage);
        this.busyThread.setPriority(7);
        this.busyThread.setDaemon(true);
        this.busyThread.start();
    }

    public void dispose() {
        if (this.busyThread != null) {
            this.busyThread.setStop(true);
            this.busyThread = null;
        }
        super.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBusy() {
        return this.busyThread != null;
    }

    protected void onPaint(PaintEvent event) {
        Image activeImage;
        if (this.animationImage != null && this.animationImage.isDisposed()) {
            this.animationImage = null;
        }
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        Image image = activeImage = this.animationImage != null ? this.animationImage : this.image;
        if (activeImage != null) {
            Rectangle ibounds = activeImage.getBounds();
            gc.drawImage(activeImage, rect.width / 2 - ibounds.width / 2, rect.height / 2 - ibounds.height / 2);
        }
    }

    public synchronized void setBusy(boolean busy) {
        if (busy) {
            if (this.busyThread == null) {
                this.createBusyThread();
            }
        } else if (this.busyThread != null) {
            this.busyThread.setStop(true);
            this.busyThread = null;
        }
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }

    private ImageDescriptor createImageDescriptor(String relativePath) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.forms");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.resolve((URL)url);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private synchronized Image getImage(int index) {
        if (this.imageCache == null) {
            this.imageCache = new Image[8];
        }
        if (this.imageCache[index] == null) {
            ImageDescriptor descriptor = this.createImageDescriptor("$nl$/icons/progress/ani/" + (index + 1) + ".png");
            this.imageCache[index] = descriptor.createImage();
        }
        return this.imageCache[index];
    }

    private synchronized void clearImages() {
        if (this.busyThread != null) {
            return;
        }
        if (this.imageCache != null) {
            int index = 0;
            while (index < 8) {
                if (this.imageCache[index] != null && !this.imageCache[index].isDisposed()) {
                    this.imageCache[index].dispose();
                    this.imageCache[index] = null;
                }
                ++index;
            }
        }
    }

    static /* synthetic */ void access$0(BusyIndicator busyIndicator) {
        busyIndicator.clearImages();
    }

    static /* synthetic */ Image access$1(BusyIndicator busyIndicator, int n) {
        return busyIndicator.getImage(n);
    }

    class BusyThread
    extends Thread {
        Rectangle bounds;
        Display display;
        GC offScreenImageGC;
        Image offScreenImage;
        Image timage;
        boolean stop;

        private BusyThread(Rectangle bounds, Display display, GC offScreenImageGC, Image offScreenImage) {
            this.bounds = bounds;
            this.display = display;
            this.offScreenImageGC = offScreenImageGC;
            this.offScreenImage = offScreenImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block19: {
                FormUtil.setAntialias(this.offScreenImageGC, 1);
                this.display.syncExec(new Runnable(this){
                    final /* synthetic */ BusyThread this$1;
                    {
                        this.this$1 = busyThread;
                    }

                    public void run() {
                        if (!BusyThread.access$1(this.this$1).isDisposed()) {
                            BusyThread.access$1(this.this$1).drawBackground(this.this$1.offScreenImageGC, 0, 0, this.this$1.bounds.width, this.this$1.bounds.height);
                        }
                    }
                });
                if (!BusyIndicator.this.isDisposed()) break block19;
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(this){
                        final /* synthetic */ BusyThread this$1;
                        {
                            this.this$1 = busyThread;
                        }

                        public void run() {
                            if (this.this$1.offScreenImage != null && !this.this$1.offScreenImage.isDisposed()) {
                                this.this$1.offScreenImage.dispose();
                            }
                            if (this.this$1.offScreenImageGC != null && !this.this$1.offScreenImageGC.isDisposed()) {
                                this.this$1.offScreenImageGC.dispose();
                            }
                        }
                    });
                }
                BusyIndicator.access$0(BusyIndicator.this);
                return;
            }
            try {
                try {
                    imageDataIndex = 0;
                    var3_2 = BusyIndicator.this;
                    synchronized (var3_2) {
                        this.timage = BusyIndicator.access$1(BusyIndicator.this, imageDataIndex);
                        imageData = this.timage.getImageData();
                        this.offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 6] lbl18 : MonitorExitStatement: MONITOREXIT : var3_2
                        if (true) ** GOTO lbl43
                    }
                    do {
                        fimageData = imageData;
                        this.display.syncExec(new Runnable(this, fimageData){
                            final /* synthetic */ BusyThread this$1;
                            private final /* synthetic */ ImageData val$fimageData;
                            {
                                this.this$1 = busyThread;
                                this.val$fimageData = imageData;
                            }

                            public void run() {
                                if (!BusyThread.access$1(this.this$1).isDisposed()) {
                                    BusyThread.access$1(this.this$1).drawBackground(this.this$1.offScreenImageGC, this.val$fimageData.x, this.val$fimageData.y, this.val$fimageData.width, this.val$fimageData.height);
                                }
                            }
                        });
                        var4_4 = BusyIndicator.this;
                        synchronized (var4_4) {
                            imageDataIndex = (imageDataIndex + 1) % 8;
                            this.timage = BusyIndicator.access$1(BusyIndicator.this, imageDataIndex);
                            imageData = this.timage.getImageData();
                            this.offScreenImageGC.drawImage(this.timage, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        }
                        BusyIndicator.this.animationImage = this.offScreenImage;
                        this.display.syncExec(new Runnable(this){
                            final /* synthetic */ BusyThread this$1;
                            {
                                this.this$1 = busyThread;
                            }

                            public void run() {
                                if (!BusyThread.access$1(this.this$1).isDisposed()) {
                                    BusyThread.access$1(this.this$1).redraw();
                                }
                            }
                        });
                        try {
                            Thread.sleep(180L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
lbl43:
                        // 3 sources

                    } while (!this.stop && !BusyIndicator.this.isDisposed() && this.timage != null);
                }
                catch (Exception v2) {
                    if (!this.display.isDisposed()) {
                        this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    BusyIndicator.access$0(BusyIndicator.this);
                }
            }
            catch (Throwable var5_6) {
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                BusyIndicator.access$0(BusyIndicator.this);
                throw var5_6;
            }
            if (!this.display.isDisposed()) {
                this.display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
            BusyIndicator.access$0(BusyIndicator.this);
            if (BusyIndicator.this.busyThread == null && !this.display.isDisposed()) {
                this.display.syncExec(new Runnable(this){
                    final /* synthetic */ BusyThread this$1;
                    {
                        this.this$1 = busyThread;
                    }

                    public void run() {
                        BusyThread.access$1((BusyThread)this.this$1).animationImage = null;
                        if (!BusyThread.access$1(this.this$1).isDisposed()) {
                            BusyThread.access$1(this.this$1).redraw();
                        }
                    }
                });
            }
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        static /* synthetic */ BusyIndicator access$1(BusyThread busyThread) {
            return busyThread.BusyIndicator.this;
        }
    }
}

