/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.move.model.IMoveModel;
import edu.mit.semantics.ui.content.MoveContentProvider;
import edu.mit.semantics.ui.controllers.IMoveController;
import edu.mit.semantics.ui.controllers.MoveController;
import edu.mit.semantics.ui.label.FunctionDisplayText;
import edu.mit.semantics.ui.label.MoveLabelProvider;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;

public class MoveCreatorPage
extends HelperPage
implements ICreatorPage {
    public static final String ID = MoveCreatorPage.class.getCanonicalName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Function";
    public static String actionLabelSave = "Save Function";
    public static String actionLabelClear = "Clear Function";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new move", 1);
    public static IMessageProvider commitMessage = new Message("Press the 'commit' button to add this move to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this move in the story model", 1);
    public static IMessageProvider addMessage = new Message("Press the 'add' button to add this function to the move", 3);
    protected IMoveController controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected DescCaptureWidget<IDescController<IDescModel>> functionWidget;
    protected Button addFunctionButton;
    protected ButtonAction addFunctionAction;
    protected TreeViewer moveViewer;
    protected Spinner numberSpinner;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;
    protected IAction deleteAction;

    public IMoveController getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new MoveController("edu.mit.story.ui.annotation.target0", this.getStoryEditor());
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        SashForm sash = new SashForm(control, 256);
        ColorManager.inheritColors((Control)sash);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite widgets = new Composite((Composite)sash, 0);
        widgets.setBackground(sash.getBackground());
        widgets.setForeground(sash.getForeground());
        widgets.setLayoutData((Object)new GridData(4, 0, true, false));
        widgets.setLayout((Layout)new GridLayout(2, false));
        this.createControlNumber(widgets);
        this.createControlFunction(widgets);
        this.createControlButtons(widgets);
        this.moveViewer = new TreeViewer((Composite)sash, 2820);
        this.moveViewer.setContentProvider((IContentProvider)new MoveContentProvider(this.getStoryEditor()));
        this.moveViewer.setLabelProvider((IBaseLabelProvider)new MoveLabelProvider(this.getStoryEditor()));
        this.moveViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.getController().getModel()}));
        this.moveViewer.setAutoExpandLevel(-1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.moveViewer);
        ColorManager.inheritColors((Control)this.moveViewer.getTree());
        this.deleteAction = new DeleteFunctionAction();
        MenuManager m = new MenuManager();
        m.add((IContributionItem)new Separator("group.edit"));
        m.appendToGroup("group.edit", this.deleteAction);
        this.moveViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDesc func = (IDesc)SelectionUtils.extractSingle((ISelection)event.getSelection(), IDesc.class);
                boolean enable = func != null && FunctionRep.getInstance().isType((IHasRep)func);
                MoveCreatorPage.this.deleteAction.setEnabled(enable);
            }
        });
        this.moveViewer.getTree().setMenu(m.createContextMenu((Control)this.moveViewer.getTree()));
        sash.setWeights(new int[]{2, 1});
        this.messageManager = new MessageProviderManager();
        this.messageManager.setDefaultMesage(commitMessage);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getFunctionController().getDescModel(), true);
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MoveCreatorPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void createControlNumber(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Number");
        this.numberSpinner = new Spinner(parent, 2048);
        this.numberSpinner.setMinimum(1);
        this.numberSpinner.setMaximum(Integer.MAX_VALUE);
        this.numberSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MoveCreatorPage.this.controller.setNumber(MoveCreatorPage.this.numberSpinner.getSelection());
            }
        });
    }

    protected void createControlFunction(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Add a Function");
        this.functionWidget = new DescCaptureWidget<IDescController<IDescModel>>(parent, 0, this.controller.getFunctionController(), (IDescDisplayText)FunctionDisplayText.getInstance()){

            protected void createFollowingControls(Composite parent) {
                parent.setLayout((Layout)MoveCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                MoveCreatorPage.this.addFunctionButton = new Button(parent, 0);
                ColorManager.inheritColors((Control)MoveCreatorPage.this.addFunctionButton);
                MoveCreatorPage.this.addFunctionButton.setText("Add");
                MoveCreatorPage.this.addFunctionAction = new ButtonAction(MoveCreatorPage.this.addFunctionButton){

                    public void run() {
                        MoveCreatorPage.this.getController().addFunction();
                    }
                };
            }
        };
        ColorManager.inheritColors(this.functionWidget);
        this.functionWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createControlButtons(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite buttonParent = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttonParent);
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        label = new Label(buttonParent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                MoveCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                MoveCreatorPage.this.controller.clear();
            }
        };
    }

    protected void updateFromModel() {
        IMoveModel moveModel = this.controller.getModel();
        IDescModel funcModel = this.controller.getFunctionController().getDescModel();
        boolean enableCommit = !moveModel.isCleared();
        enableCommit &= moveModel.getMessageType() != 3;
        enableCommit &= funcModel.isCleared();
        boolean enableClear = !moveModel.isCleared() || !funcModel.isCleared();
        boolean enableAdd = !funcModel.isCleared() && funcModel.getMessageType() != 3;
        boolean isLoaded = moveModel.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        IMessageProvider defaultMsg = isLoaded ? saveMessage : commitMessage;
        IMessageProvider iMessageProvider = defaultMsg = enableAdd ? addMessage : defaultMsg;
        if (this.numberSpinner.getSelection() != moveModel.getNumber()) {
            this.numberSpinner.setSelection(moveModel.getNumber());
        }
        if (enableAdd != this.addFunctionButton.isEnabled()) {
            this.addFunctionButton.setEnabled(enableAdd);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        this.moveViewer.refresh();
        this.moveViewer.expandToLevel(2);
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        this.functionWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.functionWidget.getCaptureAction().getActionDefinitionId(), this.functionWidget.getCaptureAction());
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        this.functionWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        actionBars.setGlobalActionHandler(this.functionWidget.getClearAction().getActionDefinitionId(), this.functionWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        this.addFunctionAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.1");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        actionBars.setGlobalActionHandler(this.addFunctionAction.getActionDefinitionId(), (IAction)this.addFunctionAction);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.delete", this.deleteAction);
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    protected class DeleteFunctionAction
    extends DeleteAction {
        protected DeleteFunctionAction() {
        }

        protected void doDelete() {
            IDesc func = (IDesc)SelectionUtils.extractSingle((ISelection)MoveCreatorPage.this.moveViewer.getSelection(), IDesc.class);
            MoveCreatorPage.this.controller.deleteFunction(func);
        }
    }
}

