/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.jpropbank.frames.IExample;
import edu.mit.jpropbank.frames.IExampleArg;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class RolesetExampleLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final Pattern whitespaceRegex = Pattern.compile("\\s+");
    private final Pattern traceRegex = Pattern.compile("\\Q*trace*\\E|\\Q*T*\\E");
    private static final StyledString.Styler UNDERLINE_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
        }
    };

    public StyledString getStyledText(Object element) {
        if (element instanceof IRoleset) {
            return this.getStyledText((IRoleset)element);
        }
        return new StyledString(element.toString());
    }

    protected StyledString getStyledText(IRoleset roleset) {
        List examples = roleset.getExamples();
        if (examples.isEmpty()) {
            return new StyledString("(no examples)", StyledString.QUALIFIER_STYLER);
        }
        StyledString result = new StyledString();
        Iterator i = examples.iterator();
        while (i.hasNext()) {
            result.append(this.getStyledString(roleset, (IExample)i.next()));
            if (!i.hasNext()) continue;
            result.append("\n\n");
        }
        return result;
    }

    protected StyledString getStyledString(IRoleset roleset, IExample ex) {
        StyledString result = new StyledString();
        result.append(ex.getName(), UNDERLINE_STYLER);
        result.append(" - ");
        result.append(this.normalize(ex.getText()));
        result.append("\n");
        Iterator i = ex.getArguments().iterator();
        while (i.hasNext()) {
            IRole role;
            IExampleArg arg = (IExampleArg)i.next();
            result.append("\t ");
            result.append(arg.getLabel());
            if (arg.getFeature().length() > 0) {
                result.append('-');
                result.append(arg.getFeature());
            }
            if ((role = roleset.getRole(arg.getLabel(), arg.getFeature())) != null) {
                result.append(' ');
                result.append(role.getDescription(), StyledString.COUNTER_STYLER);
            }
            result.append(": ");
            result.append(this.normalize(arg.getText()));
            if (!i.hasNext()) continue;
            result.append("\n");
        }
        return result;
    }

    protected String normalize(String str) {
        str = this.whitespaceRegex.matcher(str).replaceAll(" ");
        str = this.traceRegex.matcher(str).replaceAll("");
        return str;
    }

    public Image getImage(Object element) {
        return null;
    }
}

