/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.menu;

import edu.mit.story.ui.views.CreatorView;
import edu.mit.story.ui.widgets.HelperPageBookWidget;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

public class CreatorMenuProvider
extends CompoundContributionItem {
    private static final Comparator<ActionContributionItem> comparator = new ContribItemComparator();
    private final IContributionItem[] emptyMenu = new IContributionItem[]{new ActionContributionItem((IAction)new NoAction())};
    private String prefix = "";

    public CreatorMenuProvider() {
    }

    public CreatorMenuProvider(String id) {
        super(id);
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        this.prefix = prefix;
    }

    protected IContributionItem[] getContributionItems() {
        CreatorView.CreatorPageBookWidget widget;
        PageBookView view;
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("edu.mit.story.ui.views.CreatorView");
        PageBookView pageBookView = view = part instanceof PageBookView ? (PageBookView)part : null;
        if (view == null) {
            return this.emptyMenu;
        }
        IPage page = view.getCurrentPage();
        if (page == null) {
            return this.emptyMenu;
        }
        Control control = page.getControl();
        CreatorView.CreatorPageBookWidget creatorPageBookWidget = widget = control instanceof CreatorView.CreatorPageBookWidget ? (CreatorView.CreatorPageBookWidget)control : null;
        if (widget == null) {
            return this.emptyMenu;
        }
        HelperPageBookWidget.HelperPageDesc creator = widget.getCurrentPage();
        if (creator == null) {
            return this.emptyMenu;
        }
        SubActionBars actionBars = creator.getActionBars();
        Map handlers = actionBars.getGlobalActionHandlers();
        if (handlers == null) {
            return this.emptyMenu;
        }
        LinkedList<ActionContributionItem> result = null;
        for (Map.Entry entry : handlers.entrySet()) {
            if (!((String)entry.getKey()).startsWith(this.prefix)) continue;
            if (result == null) {
                result = new LinkedList<ActionContributionItem>();
            }
            result.add(new ActionContributionItem((IAction)entry.getValue()));
        }
        if (result == null) {
            return this.emptyMenu;
        }
        Collections.sort(result, comparator);
        return result.toArray(new IContributionItem[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContribItemComparator
    implements Comparator<ActionContributionItem> {
        private static final String dotZero = ".0";

        protected ContribItemComparator() {
        }

        @Override
        public int compare(ActionContributionItem item1, ActionContributionItem item2) {
            String id1 = item1.getAction().getActionDefinitionId();
            String id2 = item2.getAction().getActionDefinitionId();
            if (id1 == null && id2 == null) {
                return 0;
            }
            if (id1 == null) {
                return -1;
            }
            if (id2 == null) {
                return 1;
            }
            int cmp = id1.compareTo(id2);
            if (cmp == 0) {
                return cmp;
            }
            boolean is1Zero = id1.endsWith(dotZero);
            boolean is2Zero = id2.endsWith(dotZero);
            if (is1Zero && is2Zero) {
                return cmp;
            }
            if (is1Zero) {
                return 1;
            }
            if (is2Zero) {
                return -1;
            }
            return cmp;
        }
    }

    protected class NoAction
    extends Action {
        public NoAction() {
            this.setEnabled(false);
            this.setText("(No Actions Available)");
        }
    }
}

