/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.resolutions;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.mappers.LongMapper;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.helpers.ICreatorDescriptor;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.helpers.IEditorPage;
import edu.mit.story.ui.resolutions.EditInCreatorResolution;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public static final IMarkerResolution[] emptyMarkerArray = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        return this.getEditorPageDescriptor(marker) != null;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        List<ICreatorDescriptor<ICreatorPage>> editors = this.getEditorPageDescriptor(marker);
        if (editors == null) {
            return emptyMarkerArray;
        }
        String idStr = marker.getAttribute("descIDs", "");
        List ids = LongMapper.getInstance().reconstitute(idStr);
        if (ids.isEmpty()) {
            return emptyMarkerArray;
        }
        LinkedList<EditInCreatorResolution> result = new LinkedList<EditInCreatorResolution>();
        for (Long id : ids) {
            for (ICreatorDescriptor<ICreatorPage> editor : editors) {
                result.add(new EditInCreatorResolution(id, editor));
            }
        }
        return result.toArray(new IMarkerResolution[result.size()]);
    }

    protected List<ICreatorDescriptor<ICreatorPage>> getEditorPageDescriptor(IMarker marker) {
        try {
            if (!marker.isSubtypeOf("edu.mit.story.core.marker.problem")) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        String repID = marker.getAttribute("repID", null);
        if (repID == null) {
            return null;
        }
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
        if (rep == null) {
            return null;
        }
        List ds = StoryUIPlugin.getDefault().getCreatorPageManager().getDescriptors(rep);
        if (ds == null) {
            return null;
        }
        LinkedList<ICreatorDescriptor<ICreatorPage>> editors = new LinkedList<ICreatorDescriptor<ICreatorPage>>();
        for (ICreatorDescriptor d : ds) {
            Class c = d.getCreatableClass();
            if (c == null || !IEditorPage.class.isAssignableFrom(c)) continue;
            editors.add(d);
        }
        return editors.isEmpty() ? null : editors;
    }
}

