/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.validation;

import edu.mit.story.core.validation.BaseValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.validation.ContainerValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryProjectValidator
extends BaseValidator<IPath> {
    public IMessageProvider validate(IPath path) {
        if (path == null) {
            return ContainerValidator.containerEmpty;
        }
        String projectName = path.segment(0);
        if (projectName == null) {
            String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_NoProject, (Object)projectName);
            return new Message(message, 3);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_NoProject, (Object)projectName);
            return new Message(message, 3);
        }
        try {
            if (!project.hasNature("edu.mit.story.ui.nature")) {
                String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_NotStoryProject, (Object)projectName);
                return new Message(message, 3);
            }
        }
        catch (CoreException coreException) {
            String message = NLS.bind((String)StoryUIMessages.ContainerGroup_Problem_NotStoryProject, (Object)projectName);
            return new Message(message, 3);
        }
        return null;
    }
}

