/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import com.google.common.collect.Table;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.ui.controllers.CalculateAgreementBatchController;
import edu.mit.story.ui.controllers.ICalculateAgreementBatchController;
import edu.mit.story.ui.dialogs.AgreementResultDisplayDialog;
import edu.mit.story.ui.model.CalculateAgreementBatchModel;
import edu.mit.story.ui.model.ICalculateAgreementBatchModel;
import edu.mit.story.ui.ops.CalculateAgreementOperationBatch;
import edu.mit.story.ui.wizards.page.ResourcePairSelectionPage;
import edu.mit.story.ui.wizards.page.ResourcePairsPage;
import edu.mit.story.ui.wizards.page.SpecifyStoryRepsPage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class CalculateAgreementWizardBatch
extends Wizard {
    protected final ICalculateAgreementBatchController<ICalculateAgreementBatchModel> controller;
    protected ResourcePairSelectionPage pageSelectResources;
    protected ResourcePairsPage pageSelectPairs;
    protected SpecifyStoryRepsPage pageSelectReps;

    public CalculateAgreementWizardBatch(IResource source, IResource target) {
        CalculateAgreementBatchModel model = new CalculateAgreementBatchModel();
        model.setOutput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
        this.controller = new CalculateAgreementBatchController<CalculateAgreementBatchModel>(model);
        this.controller.setSource(source == null ? null : source.getRawLocation().toFile());
        this.controller.setTarget(target == null ? null : target.getRawLocation().toFile());
        this.setWindowTitle("Calculate Agreement");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pageSelectResources = new ResourcePairSelectionPage(this.controller);
        this.addPage((IWizardPage)this.pageSelectResources);
        this.pageSelectPairs = new ResourcePairsPage(this.controller);
        this.addPage((IWizardPage)this.pageSelectPairs);
        this.pageSelectReps = new SpecifyStoryRepsPage(this.controller);
        this.addPage((IWizardPage)this.pageSelectReps);
        ((ICalculateAgreementBatchModel)this.controller.getModel()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CalculateAgreementWizardBatch.this.getContainer().updateButtons();
                CalculateAgreementWizardBatch.this.getContainer().updateMessage();
            }
        });
    }

    public boolean performFinish() {
        final Shell shell = this.getShell();
        final AtomicInteger dialogResult = new AtomicInteger();
        ICalculateAgreementBatchModel model = (ICalculateAgreementBatchModel)this.controller.getModel();
        LinkedHashMap<IFile, IFile> pairs = new LinkedHashMap<IFile, IFile>();
        for (Table.Cell cell : model.getResourcePairs().cellSet()) {
            if (!((Boolean)cell.getValue()).booleanValue()) continue;
            pairs.put((IFile)cell.getRowKey(), (IFile)cell.getColumnKey());
        }
        CalculateAgreementOperationBatch op = new CalculateAgreementOperationBatch(model.getSourceTag(), model.getTargetTag(), pairs, model.getSelected()){

            @Override
            protected void reportResults(Map<String, List<IAgreementResult>> resultMap) {
                int result = AgreementResultDisplayDialog.open(shell, resultMap);
                dialogResult.set(result);
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Status status = new Status(4, "edu.mit.story.core", "Agreement calculation failed", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            e.printStackTrace();
            return false;
        }
        return dialogResult.get() == 0;
    }

    public boolean canFinish() {
        if (((ICalculateAgreementBatchModel)this.controller.getModel()).getMessageType() == 3) {
            return false;
        }
        return !((ICalculateAgreementBatchModel)this.controller.getModel()).getIncluded().isEmpty();
    }
}

