/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.label.TransferLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TransferRepsPage
extends WizardPage {
    protected final IMergeModel mergeModel;
    protected Label sourceLabel;
    protected Label targetLabel;
    protected CheckboxTableViewer sourceReps;
    protected CheckboxTableViewer targetReps;
    protected TableViewer outputReps;
    protected Button deleteTimingsButton;
    protected Button addExactAlignMergeTagsButton;
    protected Button startMergeButton;

    public TransferRepsPage(IMergeModel mergeModel) {
        super(TransferRepsPage.class.getSimpleName(), "Select Representations", null);
        if (mergeModel == null) {
            throw new NullPointerException();
        }
        this.mergeModel = mergeModel;
        this.mergeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TransferRepsPage.this.updateFromModel();
            }
        });
    }

    public IMergeModel getModel() {
        return this.mergeModel;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        this.setControl((Control)parent);
        parent.setLayout((Layout)new GridLayout(3, false));
        this.sourceLabel = new Label(parent, 0);
        this.sourceLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)this.sourceLabel);
        this.targetLabel = new Label(parent, 0);
        this.targetLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)this.targetLabel);
        Label label = new Label(parent, 0);
        label.setText("Output");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        this.sourceReps = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.sourceReps.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceReps.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider(IMergeModel.Action.TRANSFER_FROM_SOURCE));
        this.sourceReps.setInput(this.mergeModel.getSourceTransferReps().keySet());
        this.sourceReps.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.sourceReps.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IRep rep = (IRep)event.getElement();
                if (!rep.isTransferable()) {
                    event.getCheckable().setChecked((Object)rep, false);
                    TransferRepsPage.this.mergeModel.modify(true, false, rep);
                    return;
                }
                TransferRepsPage.this.mergeModel.modify(true, event.getChecked(), rep);
            }
        });
        this.targetReps = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.targetReps.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetReps.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider(IMergeModel.Action.TRANSFER_FROM_TARGET));
        this.targetReps.setInput(this.mergeModel.getTargetTransferReps().keySet());
        this.targetReps.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetReps.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TransferRepsPage.this.mergeModel.modify(false, event.getChecked(), (IRep)event.getElement());
            }
        });
        this.outputReps = new TableViewer(parent, 2052);
        this.outputReps.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.outputReps.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider());
        this.outputReps.setInput(this.mergeModel.getOutputReps().entrySet());
        this.outputReps.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.deleteTimingsButton = new Button(buttons, 32);
        this.deleteTimingsButton.setText("Delete timings on transfer");
        this.deleteTimingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransferRepsPage.this.mergeModel.setDeleteTimings(TransferRepsPage.this.deleteTimingsButton.getSelection());
            }
        });
        this.addExactAlignMergeTagsButton = new Button(buttons, 32);
        this.addExactAlignMergeTagsButton.setText("Add merge tags for exactly aligned representations");
        this.deleteTimingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransferRepsPage.this.mergeModel.setAddExactAlignMergeTags(TransferRepsPage.this.deleteTimingsButton.getSelection());
            }
        });
        this.updateFromModel();
    }

    protected void updateFromModel() {
        this.sourceReps.refresh();
        this.targetReps.refresh();
        this.outputReps.refresh();
        boolean layout = false;
        String tag = this.mergeModel.getSourceTag();
        if (!this.sourceLabel.getText().equals(tag)) {
            this.sourceLabel.setText(tag);
            layout = true;
        }
        tag = this.mergeModel.getTargetTag();
        if (!this.targetLabel.getText().equals(tag)) {
            this.targetLabel.setText(tag);
            layout = true;
        }
        for (Map.Entry entry : this.mergeModel.getTargetTransferReps().entrySet()) {
            this.targetReps.setChecked(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.mergeModel.getSourceTransferReps().entrySet()) {
            IRep rep = (IRep)entry.getKey();
            this.sourceReps.setChecked((Object)rep, ((Boolean)entry.getValue()).booleanValue());
            this.sourceReps.setGrayed((Object)rep, !rep.isTransferable());
        }
        if (this.deleteTimingsButton.getSelection() != this.mergeModel.getDeleteTimings()) {
            this.deleteTimingsButton.setSelection(this.mergeModel.getDeleteTimings());
        }
        if (this.addExactAlignMergeTagsButton.getSelection() != this.mergeModel.getAddExactAlignMergeTags()) {
            this.addExactAlignMergeTagsButton.setSelection(this.mergeModel.getAddExactAlignMergeTags());
        }
        boolean error = !this.mergeModel.isCleared() && this.mergeModel.getMessageType() == 3;
        this.setErrorMessage(error ? this.mergeModel.getMessage() : null);
        if (layout) {
            this.getContainer().getShell().layout(true, true);
        }
    }
}

