/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards.pages;

import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.widgets.CheckOnDoubleClickListener;
import edu.mit.story.ui.widgets.CheckboxEnumGroup;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import edu.mit.wordnet.core.rep.sense.disambiguation.DisambiguationMethod;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import edu.mit.wordnet.core.rep.sense.disambiguation.PresentationOrder;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.label.WSDItemTableLabelProvider;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDPresentationOrderPage
extends WizardPage {
    public static final String WIDGET_Table_name = "PresentationOrderTable";
    RadioButtonEnumGroup<PresentationOrder> orderGroup;
    CheckboxEnumGroup<DisambiguationMethod> method;
    CheckboxTableViewer tableViewer;
    Label highCounter;
    Label selCounter;
    Button select;
    Button deselect;
    Button selectAll;
    Button deselectAll;
    PresentationOrder order = null;
    List<IDisambiguationModel> items = null;

    public WSDPresentationOrderPage(List<IDisambiguationModel> items) {
        super("wsdPresentationOrderPage", WordnetUIMessages.PAGE_WSDPresentationOrder_title, StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/importstory_wiz.gif"));
        if (items.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.order = PresentationOrder.SEQUENTIAL;
        this.items = items;
        this.setMessage(WordnetUIMessages.MSG_WSDWordSelection_message);
    }

    public void createControl(Composite parent) {
        Composite pageParent = new Composite(parent, 0);
        pageParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageParent.setLayout((Layout)layout);
        this.setControl((Control)pageParent);
        this.createTable(pageParent);
        Label note = new Label(pageParent, 0);
        note.setText(WordnetUIMessages.MSG_WSDWordSelection_note);
        note.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite counterParent = new Composite(pageParent, 0);
        GridData gd = new GridData(4, 4, true, false);
        counterParent.setLayoutData((Object)gd);
        counterParent.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        counterParent.setLayout((Layout)layout);
        this.highCounter = new Label(counterParent, 0);
        this.highCounter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.selCounter = new Label(counterParent, 0);
        this.selCounter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createCheckButtons(pageParent);
        this.createOptionsGroups(pageParent);
        this.updateHighlightedCounter();
        this.updateSelectedCounter();
    }

    protected void createTable(Composite parent) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67586);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WSDItemTableLabelProvider());
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IDisambiguationModel) {
                    ((IDisambiguationModel)element).setEnabled(event.getChecked());
                }
                WSDPresentationOrderPage.this.updateSelectedCounter();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WSDPresentationOrderPage.this.updateHighlightedCounter();
            }
        });
        Table table = this.tableViewer.getTable();
        table.setData("name", (Object)WIDGET_Table_name);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new CheckOnDoubleClickListener());
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Token");
        column = new TableColumn(table, 16384);
        column.setText("Stem");
        column = new TableColumn(table, 16384);
        column.setText("Tag");
        column = new TableColumn(table, 16384);
        column.setText("Tag Type");
        column = new TableColumn(table, 16384);
        column.setText("Senses");
        column = new TableColumn(table, 16384);
        column.setText("Position");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setInput(this.items);
        for (IDisambiguationModel item : this.items) {
            this.tableViewer.setChecked((Object)item, item.isEnabled());
        }
    }

    protected void createCheckButtons(Composite parent) {
        Composite buttonParent = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        buttonParent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonParent.setLayout((Layout)layout);
        this.select = new Button(buttonParent, 8);
        this.select.setText("Select");
        this.select.setEnabled(false);
        this.select.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = SelectionUtils.castAsStructuredSelection((ISelection)WSDPresentationOrderPage.this.tableViewer.getSelection());
                if (selection == null) {
                    return;
                }
                for (Object o : selection) {
                    if (!(o instanceof IDisambiguationModel)) continue;
                    IDisambiguationModel item = (IDisambiguationModel)o;
                    WSDPresentationOrderPage.this.tableViewer.setChecked((Object)item, true);
                    item.setEnabled(true);
                }
                WSDPresentationOrderPage.this.tableViewer.setSelection(null);
                WSDPresentationOrderPage.this.updateSelectedCounter();
            }
        });
        this.deselect = new Button(buttonParent, 8);
        this.deselect.setText("Deselect");
        this.deselect.setEnabled(false);
        this.deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = SelectionUtils.castAsStructuredSelection((ISelection)WSDPresentationOrderPage.this.tableViewer.getSelection());
                if (selection == null) {
                    return;
                }
                for (Object o : selection) {
                    if (!(o instanceof IDisambiguationModel)) continue;
                    IDisambiguationModel item = (IDisambiguationModel)o;
                    WSDPresentationOrderPage.this.tableViewer.setChecked((Object)item, false);
                    item.setEnabled(false);
                }
                WSDPresentationOrderPage.this.tableViewer.setSelection(null);
                WSDPresentationOrderPage.this.updateSelectedCounter();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = WSDPresentationOrderPage.this.tableViewer.getSelection();
                WSDPresentationOrderPage.this.select.setEnabled(!selection.isEmpty());
                WSDPresentationOrderPage.this.deselect.setEnabled(!selection.isEmpty());
                WSDPresentationOrderPage.this.updateHighlightedCounter();
            }
        });
        this.selectAll = new Button(buttonParent, 8);
        this.selectAll.setText("&Select All");
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDPresentationOrderPage.this.tableViewer.setAllChecked(true);
                for (IDisambiguationModel item : WSDPresentationOrderPage.this.items) {
                    item.setEnabled(true);
                }
                WSDPresentationOrderPage.this.updateSelectedCounter();
            }
        });
        this.deselectAll = new Button(buttonParent, 8);
        this.deselectAll.setText("&Deselect All");
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDPresentationOrderPage.this.tableViewer.setAllChecked(false);
                for (IDisambiguationModel item : WSDPresentationOrderPage.this.items) {
                    item.setEnabled(false);
                }
                WSDPresentationOrderPage.this.updateSelectedCounter();
            }
        });
    }

    protected void createOptionsGroups(Composite parent) {
        this.orderGroup = new RadioButtonEnumGroup(PresentationOrder.class);
        this.orderGroup.setNumColumns(4);
        this.orderGroup.setGroupTitle("Presentation Order");
        this.orderGroup.setUseGroup(true);
        this.orderGroup.createComposite(parent, 0);
        this.orderGroup.getComposite().setLayoutData((Object)new GridData(4, 4, false, false));
        this.orderGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PresentationOrder newOrder = (PresentationOrder)WSDPresentationOrderPage.this.orderGroup.getValue();
                WSDPresentationOrderPage.this.setOrder(newOrder);
            }
        });
        this.method = new CheckboxEnumGroup(DisambiguationMethod.class);
        this.method.setUseGroup(true);
        this.method.setGroupTitle("Disambiguation Method");
        this.method.setNumColumns(1);
        this.method.createComposite(parent, 0);
        this.method.getComposite().setLayoutData((Object)new GridData(4, 4, false, false));
    }

    public Set<DisambiguationMethod> getMethods() {
        return this.method.getValues();
    }

    protected void updateHighlightedCounter() {
        StringBuilder sb = new StringBuilder();
        sb.append("Highlighted: ");
        IStructuredSelection sel = SelectionUtils.castAsStructuredSelection((ISelection)this.tableViewer.getSelection());
        if (sel == null) {
            sb.append("0");
        } else {
            sb.append(Integer.toString(sel.size()));
        }
        this.highCounter.setText(sb.toString());
    }

    protected void updateSelectedCounter() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected: ");
        int i = 0;
        for (IDisambiguationModel item : this.items) {
            if (!item.isEnabled()) continue;
            ++i;
        }
        sb.append(Integer.toString(i));
        sb.append("/");
        sb.append(Integer.toString(this.items.size()));
        this.selCounter.setText(sb.toString());
    }

    public boolean setOrder(PresentationOrder newOrder) {
        if (this.order == newOrder) {
            return false;
        }
        this.order = newOrder;
        this.order.sort(this.items);
        this.tableViewer.refresh();
        return true;
    }
}

