/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteIC;

public class PreferenceFileHandler {
    private String[] nameEntries;
    private String[] hostEntries;
    private String[] pathEntries;
    private String[] portEntries;
    private String[] isICEnabled = null;
    private String namePreference;
    private String hostPreference;
    private String pathPreference;
    private String portPreference;
    private String icEnabledPreference;
    private int numEntries = 0;
    private int numHostEntries = 0;
    private static String PREFERENCE_ENTRY_DELIMITER = ",";

    public PreferenceFileHandler() {
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        this.namePreference = prefs.getString("remoteHelpName");
        this.hostPreference = prefs.getString("remoteHelpHost");
        this.pathPreference = prefs.getString("remoteHelpPath");
        this.portPreference = prefs.getString("remoteHelpPort");
        this.icEnabledPreference = prefs.getString("remoteHelpICEnabled");
        if (this.hostPreference.length() == 0) {
            this.hostEntries = new String[0];
            this.numHostEntries = 0;
        } else {
            this.hostEntries = this.hostPreference.split(PREFERENCE_ENTRY_DELIMITER);
            this.numHostEntries = this.hostEntries.length;
        }
        this.nameEntries = this.getValues(this.namePreference, "");
        this.pathEntries = this.getValues(this.pathPreference, "/");
        this.portEntries = this.getValues(this.portPreference, "80");
        this.isICEnabled = this.getValues(this.icEnabledPreference, "true");
        this.numEntries = this.nameEntries == null ? 0 : this.nameEntries.length;
    }

    private String[] getValues(String preferenceEntry, String appendString) {
        if (this.numHostEntries == 0) {
            return new String[0];
        }
        String[] currEntries = preferenceEntry.split(PREFERENCE_ENTRY_DELIMITER);
        String[] updatedArray = null;
        if (currEntries.length != this.numHostEntries) {
            updatedArray = new String[this.numHostEntries];
            if (currEntries.length > this.numHostEntries) {
                int i = 0;
                while (i < this.numHostEntries) {
                    updatedArray[i] = currEntries[i];
                    ++i;
                }
            } else {
                int entryCount = 0;
                int i = 0;
                while (i < currEntries.length) {
                    updatedArray[i] = currEntries[i];
                    ++entryCount;
                    ++i;
                }
                i = entryCount;
                while (i < this.numHostEntries) {
                    updatedArray[i] = appendString;
                    ++i;
                }
            }
            currEntries = updatedArray;
        }
        return currEntries;
    }

    public static void commitRemoteICs(RemoteIC[] remoteICs) {
        RemoteIC remote_ic = null;
        String name = "";
        String host = "";
        String path = "";
        String port = "";
        String enabledString = "";
        int numICs = remoteICs.length;
        if (numICs > 0) {
            remote_ic = remoteICs[0];
            name = remote_ic.getName();
            host = remote_ic.getHost();
            path = remote_ic.getPath();
            port = remote_ic.getPort();
            boolean enabled = remote_ic.isEnabled();
            enabledString = String.valueOf(enabled);
            int i = 1;
            while (i < numICs) {
                remote_ic = remoteICs[i];
                name = String.valueOf(name) + PREFERENCE_ENTRY_DELIMITER + remote_ic.getName();
                host = String.valueOf(host) + PREFERENCE_ENTRY_DELIMITER + remote_ic.getHost();
                path = String.valueOf(path) + PREFERENCE_ENTRY_DELIMITER + remote_ic.getPath();
                port = String.valueOf(port) + PREFERENCE_ENTRY_DELIMITER + remote_ic.getPort();
                enabledString = String.valueOf(enabledString) + PREFERENCE_ENTRY_DELIMITER + remote_ic.isEnabled();
                ++i;
            }
        }
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        prefs.setValue("remoteHelpName", name);
        prefs.setValue("remoteHelpHost", host);
        prefs.setValue("remoteHelpPath", path);
        prefs.setValue("remoteHelpPort", port);
        prefs.setValue("remoteHelpICEnabled", enabledString);
        HelpBasePlugin.getDefault().savePluginPreferences();
    }

    public ArrayList getRemoteICList() {
        ArrayList<RemoteIC> remoteICList = new ArrayList<RemoteIC>();
        int totalICs = this.getTotalRemoteInfocenters();
        int i = 0;
        while (i < totalICs) {
            String host = this.getHostEntries()[i];
            String name = this.getNameEntries()[i];
            String path = this.getPathEntries()[i];
            String port = this.getPortEntries()[i];
            String enabledDisabled = this.getEnabledEntries()[i];
            boolean currEnabled = enabledDisabled.equalsIgnoreCase("true");
            RemoteIC initRemoteIC = new RemoteIC(currEnabled, name, host, path, port);
            remoteICList.add(initRemoteIC);
            ++i;
        }
        return remoteICList;
    }

    public String[] getHostEntries() {
        return this.hostEntries;
    }

    public String[] getNameEntries() {
        return this.nameEntries;
    }

    public String[] getPathEntries() {
        return this.pathEntries;
    }

    public String[] getPortEntries() {
        return this.portEntries;
    }

    public String[] getEnabledEntries() {
        return this.isICEnabled;
    }

    public int getTotalRemoteInfocenters() {
        return this.numEntries;
    }

    public String[] isEnabled() {
        return this.isICEnabled;
    }

    public String getDelimeter() {
        return PREFERENCE_ENTRY_DELIMITER;
    }
}

