/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context;

import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.SynsetID;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.rep.context.ContextArg;
import edu.mit.semantics.core.rep.context.ContextRole;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextArgMapper
implements IValueMapper<IContextArg> {
    private final IDictionary dict;
    private final IStoryData data;

    public ContextArgMapper(IDictionary dict, IStoryData data) {
        if (dict == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
        this.data = data;
    }

    public String serialize(Collection<? extends IContextArg> args) {
        return ContextArgMapper.serializeStatic(args);
    }

    public static String serializeStatic(Collection<? extends IContextArg> args) {
        ArrayList<String> fields = new ArrayList<String>(2);
        for (IContextArg iContextArg : args) {
            fields.add(ContextArgMapper.serializeArgStatic(iContextArg));
        }
        return BlockMapper.PIPE.serialize(fields);
    }

    public static String serializeArgStatic(IContextArg arg) {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add(Integer.toString(arg.getExclusionGroup()));
        IContextRole role = arg.getRole();
        fields.add(role.getType().name());
        switch (role.getType()) {
            case WORDNET: {
                fields.add(((ISynsetID)role.getWordnetRole().getID()).toString());
                break;
            }
            case PROPBANK: {
                fields.add(ContextArgMapper.serializePropbankRole(role.getPropbankRole()));
                break;
            }
            default: {
                fields.add("");
            }
        }
        fields.add(Long.toString(arg.getFiller().getID()));
        fields.add(Integer.toString(arg.getDepth()));
        return BlockMapper.COMMA.serialize(fields);
    }

    public static String serializePropbankRole(IRole role) {
        ArrayList<String> fields = new ArrayList<String>(3);
        fields.add(role.getRoleset().getID());
        fields.add(role.getLabel());
        if (role.getFeature().length() > 0) {
            fields.add(role.getFeature());
        }
        return BlockMapper.DASH.serialize(fields);
    }

    public List<IContextArg> reconstitute(String value) {
        List fields = BlockMapper.PIPE.reconstitute(value);
        ArrayList<IContextArg> result = new ArrayList<IContextArg>(fields.size());
        for (String field : fields) {
            result.add(this.reconstituteArg(field));
        }
        return result;
    }

    public IContextArg reconstituteArg(String value) {
        List fields = BlockMapper.COMMA.reconstitute(value);
        int group = Integer.parseInt((String)fields.get(0));
        IContextRole.RoleType type = IContextRole.RoleType.valueOf((String)fields.get(1));
        IContextRole role = null;
        String id = (String)fields.get(2);
        switch (type) {
            case UNKNOWN: {
                role = IContextRole.UNKNOWN;
                break;
            }
            case NONE: {
                role = IContextRole.NONE;
                break;
            }
            case WORDNET: {
                ISynset synset = ContextArgMapper.getSynsetForID(id, this.dict);
                role = new ContextRole(synset);
                break;
            }
            case PROPBANK: {
                IRole pbRole = ContextArgMapper.getPropbankRoleForID(id);
                role = new ContextRole(pbRole);
            }
        }
        long fillerID = Long.parseLong((String)fields.get(3));
        IDesc filler = this.data.getDescription(fillerID);
        int depth = Integer.parseInt((String)fields.get(4));
        return new ContextArg(group, role, filler, depth);
    }

    public static ISynset getSynsetForID(String id, IDictionary dict) {
        SynsetID sid = SynsetID.parseSynsetID((String)id);
        if (sid == null) {
            return null;
        }
        return dict.getSynset((ISynsetID)sid);
    }

    public static IRole getPropbankRoleForID(String id) {
        List fields = BlockMapper.DASH.reconstitute(id);
        IRoleset roleset = (IRoleset)SemanticsPlugin.getDefault().getFrameManager().getRoleSets().get(fields.get(0));
        if (roleset == null) {
            return null;
        }
        String feature = fields.size() > 2 ? (String)fields.get(2) : "";
        return roleset.getRole((String)fields.get(1), feature);
    }
}

