/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context;

import edu.mit.semantics.core.rep.context.ContextArg;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextRelation
implements IContextRelation {
    private final ISegmentSet signal;
    private final List<IContextArg> args;

    public ContextRelation(Collection<? extends ISegment> signal, IContextArg ... args) {
        this(signal, Arrays.asList(args));
    }

    public ContextRelation(Collection<? extends ISegment> signal, Collection<? extends IContextArg> args) {
        if (args.size() < 2) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<IContextArg> argSet = new LinkedHashSet<IContextArg>();
        for (IContextArg iContextArg : args) {
            if (iContextArg == null) {
                throw new NullPointerException();
            }
            argSet.add(iContextArg);
        }
        this.signal = signal == null ? null : new SegmentSet(signal);
        this.args = Collections.unmodifiableList(new ArrayList(argSet));
    }

    @Override
    public ISegmentSet getSignal() {
        return this.signal;
    }

    public List<IContextArg> getArguments() {
        return this.args;
    }

    public IHasPosition calculatePosition() {
        return PositionUtils.combineAll(this.args);
    }

    public IHasPosition getDisplayPosition() {
        return PositionUtils.combine((IHasPosition)this.signal, (IHasPosition)PositionUtils.combineAll(this.args));
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        boolean changed = false;
        ArrayList<IContextArg> newArgs = new ArrayList<IContextArg>(this.args.size());
        for (IContextArg oldArg : this.args) {
            IContextArg newArg = (IContextArg)oldArg.recalculate(container, model);
            if (newArg == null) continue;
            newArgs.add(newArg);
            if (oldArg == newArg) continue;
            changed = true;
        }
        if (newArgs.size() < 2) {
            return null;
        }
        ISegmentSet newSignal = null;
        if (this.signal != null) {
            newSignal = (ISegmentSet)this.signal.recalculate(container, model);
        }
        if (newSignal != this.signal) {
            changed = true;
        }
        if (!changed) {
            return this;
        }
        return new ContextRelation((Collection<? extends ISegment>)newSignal, newArgs);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!(tgtData instanceof ContextRelation)) {
            return false;
        }
        ContextRelation tgtRel = (ContextRelation)tgtData;
        if (!ContextArg.equals(this.args, tgtRel.getArguments(), model)) {
            return false;
        }
        return Data.equals((IData)this.signal, (IData)tgtRel.getSignal(), (IAlignedStoryModel)model);
    }
}

