/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.mentalstate.rules;

import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.core.rep.mentalstate.problems.UnspecifiedValenceProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoUnspecifiedValences
extends AbstractBuildRule {
    public static final String ID = NoUnspecifiedValences.class.getCanonicalName();

    public NoUnspecifiedValences() {
        super(MentalStateRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        if (!model.supports(MentalStateRep.getInstance())) {
            return null;
        }
        DescSet problems = new DescSet(MentalStateRep.getInstance());
        for (IDesc stateD : model.getData().getDescriptions(MentalStateRep.getInstance())) {
            IMentalState state = (IMentalState)stateD.getData();
            switch (state.getValence()) {
                case UNKNOWN: 
                case UNSPECIFIED: {
                    problems.add(stateD);
                }
            }
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : problems) {
            result.add((Object)new UnspecifiedValenceProblem(d, this.getID()));
        }
        return result;
    }
}

