/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class NoLinkProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.timelink.problem.noTimeLink";

    public NoLinkProblem(IDesc desc, String buildRuleID) {
        super(TimeLinkRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("no time link");
        this.setCheck(ID);
        this.setSeverity(2);
        this.setDescs(Collections.singleton(desc));
        IDescSet events = this.getDescs().getDescriptions(EventRep.getInstance());
        IDescSet times = this.getDescs().getDescriptions(Timex3Rep.getInstance());
        if (!events.isEmpty()) {
            this.setPosition((IHasPosition)desc);
            StringBuilder sb = new StringBuilder();
            IEvent event = (IEvent)desc.getData();
            sb.append("The event '");
            sb.append(event.getEventTokens().getDisplayText());
            sb.append("' does not participant in a time link");
            this.setDescription(sb.toString());
        } else if (!times.isEmpty()) {
            this.setPosition((IHasPosition)desc);
            StringBuilder sb = new StringBuilder();
            ITimex3 time = (ITimex3)desc.getData();
            sb.append("The time '");
            sb.append(time.getExpression().getDisplayText());
            sb.append("' does not participant in a time link");
            this.setDescription(sb.toString());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

