/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.text.ParseException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.DepthComboHelper;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutWizardCheckoutAsWithoutProjectFilePage
extends WizardPage {
    private Label textLabel;
    private Button wizardButton;
    private Button projectButton;
    private Text projectText;
    private Button existingButton;
    private Text revisionText;
    private Button headButton;
    private Combo depthCombo;
    private Button ignoreExternalsButton;
    private Button forceButton;
    private static final int REVISION_WIDTH_HINT = 40;

    public CheckoutWizardCheckoutAsWithoutProjectFilePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        ISVNRemoteFolder[] remoteFolders = wizard.getRemoteFolders();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.textLabel = new Label(outerContainer, 0);
        GridData data = new GridData(768);
        this.textLabel.setLayoutData((Object)data);
        if (remoteFolders != null) {
            this.textLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.single", remoteFolders[0].getName()));
        }
        this.wizardButton = new Button(outerContainer, 16);
        this.wizardButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.wizard"));
        this.projectButton = new Button(outerContainer, 16);
        this.projectButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.project"));
        Composite projectGroup = new Composite(outerContainer, 0);
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 2;
        projectGroup.setLayout((Layout)projectLayout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.projectName"));
        this.projectText = new Text(projectGroup, 2048);
        data = new GridData(768);
        this.projectText.setLayoutData((Object)data);
        if (remoteFolders != null) {
            this.projectText.setText(remoteFolders[0].getName());
        }
        this.projectText.setEnabled(false);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizard wizard = (CheckoutWizard)CheckoutWizardCheckoutAsWithoutProjectFilePage.this.getWizard();
                wizard.setProjectName(CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectText.getText().trim());
                CheckoutWizardCheckoutAsWithoutProjectFilePage.this.setPageComplete(CheckoutWizardCheckoutAsWithoutProjectFilePage.this.canFinish());
            }
        });
        this.existingButton = new Button(outerContainer, 16);
        this.existingButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.existing"));
        this.existingButton.setEnabled(false);
        this.existingButton.setVisible(false);
        this.wizardButton.setSelection(true);
        Composite revisionGroup = new Composite(outerContainer, 0);
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionLayout.marginWidth = 0;
        revisionLayout.marginHeight = 0;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(4, 4, true, false);
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button(revisionGroup, 32);
        this.headButton.setText(Policy.bind("CheckoutWizard.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.headButton.setSelection(true);
        Label revisionLabel = new Label(revisionGroup, 0);
        revisionLabel.setText(Policy.bind("CheckoutWizard.revision"));
        this.revisionText = new Text(revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        Button logButton = new Button(revisionGroup, 8);
        logButton.setText(Policy.bind("MergeDialog.showLog"));
        logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithoutProjectFilePage.this.showLog();
            }
        });
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithoutProjectFilePage.this.revisionText.setEnabled(!CheckoutWizardCheckoutAsWithoutProjectFilePage.this.headButton.getSelection());
                if (!CheckoutWizardCheckoutAsWithoutProjectFilePage.this.headButton.getSelection()) {
                    CheckoutWizardCheckoutAsWithoutProjectFilePage.this.revisionText.selectAll();
                    CheckoutWizardCheckoutAsWithoutProjectFilePage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)revisionListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectText.setEnabled(CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectButton.getSelection());
                if (CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectButton.getSelection()) {
                    CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectText.selectAll();
                    CheckoutWizardCheckoutAsWithoutProjectFilePage.this.projectText.setFocus();
                }
                CheckoutWizardCheckoutAsWithoutProjectFilePage.this.setPageComplete(CheckoutWizardCheckoutAsWithoutProjectFilePage.this.canFinish());
            }
        };
        this.wizardButton.addSelectionListener((SelectionListener)selectionListener);
        this.projectButton.addSelectionListener((SelectionListener)selectionListener);
        this.existingButton.addSelectionListener((SelectionListener)selectionListener);
        Group parameterGroup = new Group(outerContainer, 0);
        GridLayout parameterLayout = new GridLayout();
        parameterLayout.numColumns = 2;
        parameterGroup.setLayout((Layout)parameterLayout);
        data = new GridData(4, 4, true, false, 3, 1);
        parameterGroup.setLayoutData((Object)data);
        Label depthLabel = new Label((Composite)parameterGroup, 0);
        depthLabel.setText(Policy.bind("SvnDialog.depth"));
        this.depthCombo = new Combo((Composite)parameterGroup, 8);
        DepthComboHelper.addDepths(this.depthCombo, false, "Fully recursive");
        this.ignoreExternalsButton = new Button((Composite)parameterGroup, 32);
        this.ignoreExternalsButton.setText(Policy.bind("SvnDialog.ignoreExternals"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreExternalsButton.setLayoutData((Object)data);
        this.forceButton = new Button((Composite)parameterGroup, 32);
        this.forceButton.setText(Policy.bind("SvnDialog.force"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.forceButton.setLayoutData((Object)data);
        this.forceButton.setSelection(true);
        this.setMessage(Policy.bind("CheckoutWizardCheckoutAsPage.text"));
        this.setControl((Control)outerContainer);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public void setProject(String project) {
        this.projectText.setText(project);
    }

    public boolean useWizard() {
        return this.wizardButton.getSelection();
    }

    private boolean canFinish() {
        return !this.projectButton.getSelection() || this.projectText.getText().trim().length() > 0;
    }

    private void showLog() {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.getCommonParent());
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
        this.revisionText.setEnabled(true);
        this.headButton.setSelection(false);
    }

    private ISVNRemoteResource getCommonParent() {
        ISVNRemoteFolder[] remoteFolders = ((CheckoutWizard)this.getWizard()).getRemoteFolders();
        if (remoteFolders.length == 1) {
            return remoteFolders[0];
        }
        ISVNRemoteFolder commonParent = null;
        ISVNRemoteFolder parent = remoteFolders[0];
        while (commonParent == null) {
            if ((parent = parent.getParent()) == null) break;
            int i = 1;
            while (i < remoteFolders.length) {
                if (!remoteFolders[i].getUrl().toString().startsWith(parent.getUrl().toString())) break;
                ++i;
            }
            commonParent = parent;
        }
        return commonParent;
    }

    public SVNRevision getRevision() {
        if (this.headButton.getSelection()) {
            return SVNRevision.HEAD;
        }
        SVNRevision svnRevision = null;
        try {
            svnRevision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
        }
        catch (ParseException parseException) {}
        if (svnRevision == null) {
            return SVNRevision.HEAD;
        }
        return svnRevision;
    }

    public int getDepth() {
        return DepthComboHelper.getDepth(this.depthCombo);
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternalsButton.getSelection();
    }

    public boolean isForce() {
        return this.forceButton.getSelection();
    }
}

